/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.attachment;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.attachments.builtin.ExternalAuthorizationAttachment;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ExternalAuthorizationTab
extends SettingsSubTab
implements IScrollable {
    public static final int ROWS = 3;
    private String selectedMachine = null;
    private DropdownWidget accessSelection;
    private int scroll = 0;

    public ExternalAuthorizationTab(TraderSettingsClientTab parent) {
        super(parent);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_COUNT;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_EXTERNAL_AUTH.get(new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("allowExternalAuthorization") && !this.getPossibleTargets().isEmpty();
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(3, this.getPossibleTargets().size());
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        if (firstOpen) {
            this.selectedMachine = null;
        }
        for (int i = 0; i < 3; ++i) {
            int index = i;
            this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 20 + 20 * i))).width(screenArea.width - 40)).text(() -> EasyText.literal(this.getPossibleTarget(index))).addon(EasyAddonHelper.visibleCheck(() -> this.doesTargetExist(index)))).addon(EasyAddonHelper.activeCheck(() -> !this.isTargetSelected(index)))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_SETTINGS_EXTERNAL_AUTH_SELECT))).pressAction(() -> this.selectTarget(index))).build());
        }
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos.offset(20, 20))).size(screenArea.width - 40, 60)).listener(this).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(screenArea.width - 20, 20))).height(60).scrollable(this).build());
        this.accessSelection = this.addChild(((DropdownWidget.Builder)((DropdownWidget.Builder)DropdownWidget.builder().position(screenArea.pos.offset(20, 100))).width(screenArea.width - 40).enumOptions(LCText.GUI_TRADER_SETTINGS_EXTERNAL_AUTH_ACCESS_LEVEL, ExternalAuthorizationAttachment.AccessLevel.values()).addon(EasyAddonHelper.visibleCheck(() -> this.selectedMachine != null))).selected(this.getSelectedAccessLevel().ordinal()).selectAction(this::changeAccessLevel).build());
    }

    private boolean doesTargetExist(int internalIndex) {
        return !this.getPossibleTarget(internalIndex).isEmpty();
    }

    private boolean isTargetSelected(int internalIndex) {
        return this.selectedMachine != null && Objects.equals(this.selectedMachine, this.getPossibleTarget(internalIndex));
    }

    private String getPossibleTarget(int internalIndex) {
        List<String> attemptedAccessors = this.getPossibleTargets();
        int index = this.scroll + internalIndex;
        if (index >= 0 && index < attemptedAccessors.size()) {
            return attemptedAccessors.get(index);
        }
        return "";
    }

    private List<String> getPossibleTargets() {
        TraderData trader = this.menu.getTrader();
        if (trader != null && trader.hasAttachment(ExternalAuthorizationAttachment.TYPE)) {
            return trader.getAttachment(ExternalAuthorizationAttachment.TYPE).getAttemptedAccessors();
        }
        return new ArrayList<String>();
    }

    private void selectTarget(int internalIndex) {
        List<String> attemptedAccessors = this.getPossibleTargets();
        int index = this.scroll + internalIndex;
        if (index >= 0 && index < attemptedAccessors.size()) {
            this.selectedMachine = attemptedAccessors.get(index);
            if (this.accessSelection != null) {
                this.accessSelection.setCurrentlySelected(this.getSelectedAccessLevel().ordinal());
            }
        }
    }

    private ExternalAuthorizationAttachment.AccessLevel getSelectedAccessLevel() {
        if (this.selectedMachine == null) {
            return ExternalAuthorizationAttachment.AccessLevel.NONE;
        }
        TraderData trader = this.menu.getTrader();
        if (trader != null && trader.hasAttachment(ExternalAuthorizationAttachment.TYPE)) {
            return trader.getAttachment(ExternalAuthorizationAttachment.TYPE).getAccessLevel(this.selectedMachine);
        }
        return ExternalAuthorizationAttachment.AccessLevel.NONE;
    }

    private void changeAccessLevel(int ordinal) {
        if (this.selectedMachine == null) {
            return;
        }
        if (this.getSelectedAccessLevel().ordinal() == ordinal) {
            return;
        }
        this.menu.SendMessage(this.builder().setString(String.valueOf(ExternalAuthorizationAttachment.TYPE) + "-ChangeAuthorization", this.selectedMachine).setInt(String.valueOf(ExternalAuthorizationAttachment.TYPE) + "-NewLevel", ordinal));
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
    }
}

