/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.api.teams.TeamAPI;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.teams.tabs.TeamSelectionTab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TeamSelectionClientTab
extends TeamManagementClientTab<TeamSelectionTab> {
    TeamSelectWidget teamSelection;
    List<ITeam> teamList = new ArrayList<ITeam>();
    EditBox newTeamName;
    EasyButton buttonCreateTeam;

    public TeamSelectionClientTab(@Nonnull Object screen, @Nonnull TeamSelectionTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return ItemIcon.ofItem((ItemLike)Items.PAPER);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TEAM_SELECT.get(new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.refreshTeamList();
        this.teamSelection = this.addChild(((TeamSelectWidget.Builder)TeamSelectWidget.builder().position(screenArea.pos.offset(10, 20))).width(screenArea.width - 20).rows(5).teams(() -> this.teamList).selected(((TeamManagementMenu)this.menu)::selectedTeam).handler(this::selectTeamButton).build());
        this.newTeamName = this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 140, 160, 20, (Component)Component.empty()));
        this.newTeamName.setMaxLength(32);
        this.buttonCreateTeam = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(120, 165))).width(60)).text(LCText.BUTTON_TEAM_CREATE).pressAction(this::createTeam)).build());
        this.buttonCreateTeam.active = false;
    }

    private ITeam getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private void refreshTeamList() {
        this.teamList = new ArrayList<ITeam>();
        List<ITeam> allTeams = TeamAPI.getApi().GetAllTeams(true);
        allTeams.forEach(team -> {
            if (team.isMember(((TeamManagementMenu)this.menu).player)) {
                this.teamList.add((ITeam)team);
            }
        });
        this.teamList.sort(TeamAPI.getApi().SorterForPlayer(((TeamManagementMenu)this.menu).player));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.GUI_TEAM_SELECT.get(new Object[0]), 20, 10, 0x404040);
        gui.drawString((Component)LCText.GUI_TEAM_CREATE.get(new Object[0]), 20, 130, 0x404040);
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.buttonCreateTeam.active = !this.newTeamName.getValue().isBlank();
    }

    private void selectTeamButton(int teamIndex) {
        ITeam team = this.getTeam(teamIndex);
        if (team != null) {
            ((TeamSelectionTab)this.commonTab).SelectTeam(team.getID());
        }
    }

    private void createTeam(EasyButton button) {
        if (this.newTeamName.getValue().isBlank()) {
            return;
        }
        ((TeamSelectionTab)this.commonTab).CreateTeam(this.newTeamName.getValue());
        this.newTeamName.setValue("");
    }
}

