/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketChestQuickCollect;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;

public class ChestCoinCollectButton
extends IconButton {
    private static ChestCoinCollectButton lastButton;
    private final ContainerScreen screen;

    private ChestCoinCollectButton(@Nonnull Builder builder) {
        super(((IconButton.Builder)IconButton.builder().pressAction(CPacketChestQuickCollect::sendToServer)).icon(ChestCoinCollectButton::getIcon));
        this.screen = builder.screen;
        lastButton = this;
        this.setPosition(this.screen.getGuiLeft() + this.screen.getXSize() - this.width, this.screen.getGuiTop() - this.height);
    }

    private static IconData getIcon() {
        return ItemIcon.ofItem(CoinAPI.getApi().getEquippedWallet((Player)Minecraft.getInstance().player));
    }

    private boolean shouldBeVisible() {
        ItemStack wallet;
        if (!((Boolean)LCConfig.CLIENT.chestButtonVisible.get()).booleanValue()) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc != null && WalletItem.isWallet(wallet = CoinAPI.getApi().getEquippedWallet((Player)mc.player))) {
            boolean allowSideChains = (Boolean)LCConfig.CLIENT.chestButtonAllowSideChains.get();
            Container container = ((ChestMenu)this.screen.getMenu()).getContainer();
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack item = container.getItem(i);
                if (!CoinAPI.getApi().IsAllowedInCoinContainer(item, allowSideChains)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void renderTick() {
        super.renderTick();
        this.visible = this.shouldBeVisible();
    }

    public static void tryRenderTooltip(EasyGuiGraphics gui, int mouseX, int mouseY) {
        if (lastButton != null && lastButton.isMouseOver(mouseX, mouseY)) {
            gui.renderTooltip((Component)LCText.TOOLTIP_CHEST_COIN_COLLECTION_BUTTON.get(new Object[0]));
        }
    }

    public static Builder chestBuilder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private ContainerScreen screen = null;

        private Builder() {
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder screen(@Nonnull ContainerScreen screen) {
            this.screen = screen;
            return this;
        }

        public ChestCoinCollectButton build() {
            return new ChestCoinCollectButton(this);
        }
    }
}

