/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.BookRenderer;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.BookTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BookTraderBlockEntityRenderer
implements BlockEntityRenderer<BookTraderBlockEntity> {
    private BookTraderBlockEntityRenderer() {
    }

    public static BookTraderBlockEntityRenderer create(BlockEntityRendererProvider.Context ignored) {
        return new BookTraderBlockEntityRenderer();
    }

    public void render(@Nonnull BookTraderBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, int lightLevel, int id) {
        ItemTraderData trader = (ItemTraderData)blockEntity.getTraderData();
        if (trader == null) {
            return;
        }
        for (int tradeSlot = 0; tradeSlot < trader.getTradeCount() && tradeSlot < blockEntity.maxRenderIndex(); ++tradeSlot) {
            BookRenderer renderer;
            ItemTradeData trade = trader.getTrade(tradeSlot);
            if (!trade.hasStock(trader) || (renderer = BookTraderBlockEntityRenderer.GetRenderer(ItemTraderBlockEntityRenderer.GetRenderItems(trade, trader))) == null) continue;
            pose.pushPose();
            Vector3f offset = blockEntity.GetBookRenderPos(tradeSlot);
            List<Quaternionf> rotations = blockEntity.GetBookRenderRot(tradeSlot);
            float scale = blockEntity.GetBookRenderScale(tradeSlot);
            pose.translate(offset.x, offset.y, offset.z);
            for (Quaternionf r : rotations) {
                pose.mulPose(r);
            }
            pose.scale(scale, scale, scale);
            renderer.render(blockEntity, partialTicks, pose, buffer, lightLevel, id);
            pose.popPose();
        }
    }

    private static BookRenderer GetRenderer(List<ItemStack> renderItems) {
        for (ItemStack book : renderItems) {
            BookRenderer renderer = BookRenderer.GetRenderer(book);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }
}

