/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.GachaMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.GachaMachineBlock;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaStorage;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.joml.Quaternionf;

@ParametersAreNonnullByDefault
public class GachaMachineBlockEntityRenderer
implements BlockEntityRenderer<GachaMachineBlockEntity> {
    public static final int HEIGHT = 3;
    public static final int WIDTH = 5;
    public static final int MAX_DISPLAY_COUNT = 75;
    private final ItemRenderer itemRenderer;

    private GachaMachineBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public static GachaMachineBlockEntityRenderer create(BlockEntityRendererProvider.Context context) {
        return new GachaMachineBlockEntityRenderer(context);
    }

    public void render(GachaMachineBlockEntity be, float partialTick, PoseStack pose, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        GachaTrader trader = (GachaTrader)be.getTraderData();
        if (trader == null) {
            return;
        }
        GachaStorage storage = trader.getStorage();
        if (((Boolean)LCConfig.CLIENT.gachaMachineFancyGraphics.get()).booleanValue()) {
            RandomSource random = RandomSource.create((long)Objects.hash(be.getLevel().dimension().location(), be.getBlockPos()));
            int itemsToDraw = Math.min(75, (Integer)LCConfig.CLIENT.itemRenderLimit.get());
            if (itemsToDraw <= 0) {
                return;
            }
            List<ItemStack> contents = storage.getRandomizedContents();
            int i = 0;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 5; ++x) {
                    for (int z = 0; z < 5; ++z) {
                        if (i >= contents.size()) {
                            return;
                        }
                        ItemStack ball = contents.get(i++);
                        pose.pushPose();
                        pose.translate((3.5 + (double)x * 2.3) / 16.0, (8.33 + 2.66 * (double)y) / 16.0, (3.5 + (double)z * 2.3) / 16.0);
                        pose.scale(0.375f, 0.375f, 0.375f);
                        this.itemRenderer.renderStatic(ball, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, pose, bufferSource, null, packedOverlay);
                        pose.popPose();
                    }
                }
            }
        } else {
            int itemCount = storage.getItemCount();
            int modelIndex = -1;
            if (itemCount > 12 && itemCount <= 37) {
                modelIndex = 0;
            } else if (itemCount > 37 && itemCount <= 62) {
                modelIndex = 1;
            } else if (itemCount > 62) {
                modelIndex = 2;
            }
            if (modelIndex >= 0) {
                Quaternionf rotation = null;
                Block y = be.getBlockState().getBlock();
                if (y instanceof IRotatableBlock) {
                    IRotatableBlock rb = (IRotatableBlock)y;
                    Direction facing = rb.getFacing(be.getBlockState());
                    rotation = MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing.get2DDataValue() * -90.0f);
                }
                List<ResourceLocation> models = GachaMachineBlock.BASIC_MODELS;
                Block x = be.getBlockState().getBlock();
                if (x instanceof GachaMachineBlock) {
                    GachaMachineBlock gb = (GachaMachineBlock)x;
                    models = gb.getBasicModels();
                }
                pose.pushPose();
                pose.translate(0.5f, 0.5f, 0.5f);
                if (rotation != null) {
                    pose.mulPose(rotation);
                }
                ResourceLocation modelID = models.get(modelIndex);
                BakedModel model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)modelID));
                this.itemRenderer.render(new ItemStack((ItemLike)be.getBlockState().getBlock()), ItemDisplayContext.FIXED, false, pose, bufferSource, packedLight, OverlayTexture.NO_OVERLAY, model);
                pose.popPose();
            }
        }
    }
}

