/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.rotation;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandler;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandlerType;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;

public class FacingUpRotation
extends RotationHandler {
    public static final RotationHandlerType TYPE = FacingUpRotation::parse;
    private static final Map<Float, FacingUpRotation> cache = new HashMap<Float, FacingUpRotation>();
    private final float extraRotation;

    protected FacingUpRotation(float extraRotation) {
        super(TYPE);
        this.extraRotation = extraRotation;
    }

    public static FacingUpRotation createDefault() {
        return FacingUpRotation.create(0.0f);
    }

    public static FacingUpRotation create(float extraRotation) {
        if (!cache.containsKey(Float.valueOf(extraRotation))) {
            cache.put(Float.valueOf(extraRotation), new FacingUpRotation(extraRotation));
        }
        return cache.get(Float.valueOf(extraRotation));
    }

    @Override
    protected List<Quaternionf> rotate(BlockState state, float partialTicks) {
        Block block = state.getBlock();
        if (block instanceof IRotatableBlock) {
            IRotatableBlock rb = (IRotatableBlock)block;
            int facing = rb.getFacing(state).get2DDataValue();
            return ImmutableList.of((Object)MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing * -90.0f + this.extraRotation), (Object)MathUtil.fromAxisAngleDegree(MathUtil.getXP(), 90.0f));
        }
        return ImmutableList.of((Object)MathUtil.fromAxisAngleDegree(MathUtil.getXP(), 90.0f));
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        if (this.extraRotation != 0.0f) {
            json.addProperty("offset", (Number)Float.valueOf(this.extraRotation));
        }
    }

    private static FacingUpRotation parse(JsonObject json) throws JsonSyntaxException {
        return FacingUpRotation.create(GsonHelper.getAsFloat((JsonObject)json, (String)"offset", (float)0.0f));
    }
}

