/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data;

import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.util.WildcardTargetSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public final class TargetSelectorHelper {
    private final Map<SelectorKey, List<ResourceLocation>> ITEM_RESULTS = new HashMap<SelectorKey, List<ResourceLocation>>();
    private final Map<SelectorKey, List<ResourceLocation>> BLOCK_RESULTS = new HashMap<SelectorKey, List<ResourceLocation>>();

    public void lookupItems(List<String> targetSelectors, List<ResourceLocation> targets, int models) {
        TargetSelectorHelper.lookup(targetSelectors, targets, models, this.ITEM_RESULTS, BuiltInRegistries.ITEM, i -> {
            IVariantItem item = VariantProvider.getVariantItem(i);
            return item == null ? -1 : item.requiredModels();
        });
    }

    public void lookupBlocks(List<String> targetSelectors, List<ResourceLocation> targets, int models) {
        TargetSelectorHelper.lookup(targetSelectors, targets, models, this.BLOCK_RESULTS, BuiltInRegistries.BLOCK, b -> {
            IVariantBlock block = VariantProvider.getVariantBlock(b);
            return block == null ? -1 : block.requiredModels();
        });
    }

    private static <T> void lookup(List<String> targetSelectors, List<ResourceLocation> targets, int models, Map<SelectorKey, List<ResourceLocation>> resultCache, Registry<T> registry, Function<T, Integer> modelRequirementLookup) {
        if (targetSelectors.isEmpty()) {
            return;
        }
        ArrayList<SelectorKey> selectors = new ArrayList<SelectorKey>(targetSelectors.stream().map(WildcardTargetSelector::parse).map(s -> new SelectorKey((WildcardTargetSelector)s, models)).toList());
        for (SelectorKey s2 : new ArrayList<SelectorKey>(selectors)) {
            if (!resultCache.containsKey(s2)) continue;
            TargetSelectorHelper.addTargets(targets, resultCache.get(s2));
            selectors.remove(s2);
        }
        if (selectors.isEmpty()) {
            return;
        }
        HashMap<SelectorKey, List<ResourceLocation>> tempCache = new HashMap<SelectorKey, List<ResourceLocation>>();
        for (SelectorKey s3 : selectors) {
            tempCache.put(s3, new ArrayList());
        }
        for (Object entry : registry) {
            ResourceLocation itemID;
            int requiredModels = modelRequirementLookup.apply(entry);
            if (requiredModels < 0 || requiredModels != models || !TargetSelectorHelper.testSelectors(selectors, itemID = registry.getKey(entry), tempCache)) continue;
            TargetSelectorHelper.addTarget(targets, itemID);
        }
        resultCache.putAll(tempCache);
    }

    private static boolean testSelectors(List<SelectorKey> targetSelectors, ResourceLocation id, Map<SelectorKey, List<ResourceLocation>> tempCache) {
        String idString = id.toString();
        boolean success = false;
        for (SelectorKey s : targetSelectors) {
            if (!s.selector.matches(idString)) continue;
            tempCache.get(s).add(id);
            success = true;
        }
        return success;
    }

    private static void addTargets(List<ResourceLocation> targets, List<ResourceLocation> newTargets) {
        for (ResourceLocation newTarget : newTargets) {
            TargetSelectorHelper.addTarget(targets, newTarget);
        }
    }

    private static void addTarget(List<ResourceLocation> targets, ResourceLocation target) {
        if (targets.contains(target)) {
            return;
        }
        targets.add(target);
    }

    private record SelectorKey(WildcardTargetSelector selector, int blockModels) {
    }
}

