/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util.text_inputs;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;

public class ComponentParser
implements Function<String, Component> {
    public static final ComponentParser INSTANCE = new ComponentParser();

    private ComponentParser() {
    }

    private static HolderLookup.Provider getLookup() {
        RegistryAccess lookup = LookupHelper.getRegistryAccess();
        if (lookup == null) {
            return RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        }
        return lookup;
    }

    @Override
    public Component apply(String s) {
        try {
            return Component.Serializer.fromJsonLenient((String)s, (HolderLookup.Provider)ComponentParser.getLookup());
        }
        catch (Exception e) {
            return s.isBlank() ? null : EasyText.literal(s);
        }
    }

    public static String write(Component component) {
        return Component.Serializer.toJson((Component)component, (HolderLookup.Provider)ComponentParser.getLookup());
    }
}

