/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.api.events.WalletDropEvent;
import io.github.lightman314.lightmanscurrency.api.misc.BlockProtectionHelper;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.advancements.date.DateTrigger;
import io.github.lightman314.lightmanscurrency.common.attachments.EventUnlocks;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModAttachmentTypes;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.variant.ItemVariantSelectMenu;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.event.SPacketSyncEventUnlocks;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.SPacketSyncWallet;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@EventBusSubscriber
public class EventHandler {
    private static final List<String> PROTECTED_MODS = Lists.newArrayList((Object[])new String[]{"lightmanscurrency"});

    public static void registerMushroomProtectedMod(@Nonnull String modid) {
        if (!PROTECTED_MODS.contains(modid)) {
            PROTECTED_MODS.add(modid);
        }
    }

    @SubscribeEvent
    public static void pickupItem(ItemEntityPickupEvent.Pre event) {
        WalletItem walletItem;
        Item item;
        WalletMenuBase container;
        if (event.canPickup() == TriState.FALSE) {
            return;
        }
        ItemEntity ie = event.getItemEntity();
        ItemStack pickupItem = ie.getItem();
        Player player = event.getPlayer();
        if (ie.hasPickUpDelay() || !CoinAPI.getApi().IsAllowedInCoinContainer(pickupItem, false) || ie.getTarget() != null && !ie.getTarget().equals(player.getUUID())) {
            return;
        }
        WalletMenuBase activeContainer = null;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof WalletMenuBase && (container = (WalletMenuBase)abstractContainerMenu).isEquippedWallet()) {
            activeContainer = container;
        }
        boolean cancelEvent = false;
        WalletHandler walletHandler = WalletHandler.get((LivingEntity)player);
        ItemStack wallet = walletHandler.getWallet();
        if (!wallet.isEmpty() && (item = wallet.getItem()) instanceof WalletItem && WalletItem.CanPickup(walletItem = (WalletItem)item)) {
            cancelEvent = true;
            pickupItem = activeContainer != null ? activeContainer.PickupCoins(pickupItem) : walletHandler.PickupCoins(pickupItem);
        }
        if (cancelEvent) {
            event.getItemEntity().setItem(ItemStack.EMPTY);
            if (!pickupItem.isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)pickupItem);
            }
            if (!player.level().isClientSide) {
                WalletItem.playCollectSound((LivingEntity)player, wallet);
            }
            event.setCanPickup(TriState.FALSE);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        IOwnableBlock block;
        if (((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue()) {
            return;
        }
        LevelAccessor level = event.getLevel();
        BlockState state = event.getState();
        Block block2 = state.getBlock();
        if (block2 instanceof IOwnableBlock && !(block = (IOwnableBlock)block2).canBreak(event.getPlayer(), level, event.getPos(), state)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void blockBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue()) {
            return;
        }
        Level level = event.getEntity().level();
        BlockState state = event.getState();
        Block block = event.getState().getBlock();
        if (block instanceof IOwnableBlock) {
            IOwnableBlock block2 = (IOwnableBlock)block;
            event.getPosition().ifPresent(pos -> {
                if (!block2.canBreak(event.getEntity(), (LevelAccessor)level, (BlockPos)pos, state)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        EventHandler.sendWalletUpdatePacket(event.getEntity());
        EventHandler.sendEventUpdatePacket(event.getEntity());
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SyncedConfigFile.playerJoined(player2);
        }
    }

    @SubscribeEvent
    public static void playerStartTracking(PlayerEvent.StartTracking event) {
        LivingEntity target;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && (target = (LivingEntity)entity).hasData(ModAttachmentTypes.WALLET_HANDLER)) {
            Player player = event.getEntity();
            EventHandler.sendWalletUpdatePacket(target, player);
        }
    }

    @SubscribeEvent
    public static void playerChangedDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        EventHandler.sendEventUpdatePacket(player);
    }

    private static void sendWalletUpdatePacket(LivingEntity entity, Player target) {
        if (entity.level().isClientSide && entity.hasData(ModAttachmentTypes.WALLET_HANDLER)) {
            return;
        }
        WalletHandler walletHandler = WalletHandler.get(entity);
        new SPacketSyncWallet(entity.getId(), walletHandler.getWallet(), walletHandler.visible()).sendTo(target);
    }

    private static void sendWalletUpdatePacket(Player player) {
        EventHandler.sendWalletUpdatePacket((LivingEntity)player, player);
    }

    private static void sendEventUpdatePacket(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        EventUnlocks eventUnlocks = (EventUnlocks)player.getData(ModAttachmentTypes.EVENT_UNLOCKS);
        if (eventUnlocks != null) {
            new SPacketSyncEventUnlocks(eventUnlocks.getUnlockedList()).sendTo(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.level().isClientSide) {
            return;
        }
        if (!livingEntity.isSpectator() && livingEntity.hasData(ModAttachmentTypes.WALLET_HANDLER)) {
            WalletHandler walletHandler = WalletHandler.get(livingEntity);
            ItemStack walletStack = walletHandler.getWallet();
            if (walletStack.isEmpty() || !WalletItem.isWallet(walletStack)) {
                return;
            }
            List<ItemStack> drops = new ArrayList<ItemStack>();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                boolean keepWallet = ModGameRules.safeGetCustomBool(player.level(), ModGameRules.KEEP_WALLET, false);
                boolean destroyWallet = false;
                if (!keepWallet) {
                    LCCurios.DropRule dropRule = LCCurios.getWalletDropRules((LivingEntity)player);
                    if (dropRule.shouldDestroy()) {
                        destroyWallet = true;
                    } else {
                        keepWallet = dropRule.shouldKeep((LivingEntity)player);
                    }
                }
                int coinDropPercent = ModGameRules.safeGetCustomInt(player.level(), ModGameRules.COIN_DROP_PERCENT, 0);
                WalletDropEvent wde = new WalletDropEvent(player, walletHandler, event.getSource(), keepWallet, destroyWallet, coinDropPercent);
                if (((WalletDropEvent)NeoForge.EVENT_BUS.post((Event)wde)).isCanceled()) {
                    return;
                }
                drops = wde.getDrops();
                walletHandler.setWallet(wde.getWalletStack());
            } else {
                drops.add(walletStack);
                walletHandler.setWallet(ItemStack.EMPTY);
            }
            if (((Boolean)LCConfig.SERVER.walletDropsManualSpawn.get()).booleanValue()) {
                for (ItemEntity entity : EventHandler.turnIntoEntities(livingEntity, drops)) {
                    livingEntity.level().addFreshEntity((Entity)entity);
                }
            } else {
                event.getDrops().addAll(EventHandler.turnIntoEntities(livingEntity, drops));
            }
        }
    }

    private static List<ItemEntity> turnIntoEntities(@Nonnull LivingEntity entity, @Nonnull List<ItemStack> list) {
        ArrayList<ItemEntity> result = new ArrayList<ItemEntity>();
        for (ItemStack stack : list) {
            ItemEntity item = new ItemEntity(entity.level(), entity.position().x, entity.position().y + 1.0, entity.position().z, stack);
            item.setDefaultPickUpDelay();
            result.add(item);
        }
        return result;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onWalletDrop(@Nonnull WalletDropEvent event) {
        if (event.destroyWallet) {
            event.setWalletStack(ItemStack.EMPTY);
            event.setDrops(new ArrayList<ItemStack>());
            return;
        }
        if (event.keepWallet) {
            event.addDrops(EventHandler.getWalletDrops(event, event.coinDropPercent));
        } else {
            event.addDrop(event.getWalletStack());
            event.setWalletStack(ItemStack.EMPTY);
        }
    }

    private static List<ItemStack> getWalletDrops(@Nonnull WalletDropEvent event, int coinDropPercent) {
        if (coinDropPercent <= 0) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Container walletInventory = event.getWalletInventory();
        IMoneyHandler walletHandler = MoneyAPI.getApi().GetContainersMoneyHandler(walletInventory, drops::add, IClientTracker.entityWrapper((Entity)event.getEntity()));
        MoneyView walletFunds = walletHandler.getStoredMoney();
        for (MoneyValue value : walletFunds.allValues()) {
            MoneyValue takeAmount;
            if (!(value instanceof CoinValue) || (takeAmount = value.percentageOfValue(coinDropPercent)).isEmpty() || !(takeAmount instanceof CoinValue)) continue;
            CoinValue coinsToDrop = (CoinValue)takeAmount;
            if (!walletHandler.extractMoney(takeAmount, true).isEmpty()) continue;
            walletHandler.extractMoney(takeAmount, false);
            drops.addAll(coinsToDrop.getAsSeperatedItemList());
        }
        return drops;
    }

    @SubscribeEvent
    public static void entityTick(EntityTickEvent.Pre event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).hasData(ModAttachmentTypes.WALLET_HANDLER)) {
            WalletHandler handler = WalletHandler.get(entity);
            handler.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void serverStart(ServerStartedEvent event) {
        ConfigFile.loadServerFiles(ConfigFile.LoadPhase.GAME_START);
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post event) {
        ProfilerFiller filler;
        if (event.getServer().getTickCount() % 1200 == 0) {
            filler = event.getServer().getProfiler();
            filler.push("Date Trigger Tick");
            for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                DateTrigger.INSTANCE.trigger(player);
            }
            filler.pop();
        }
        filler = event.getServer().getProfiler();
        filler.push("Bank Account Salary Tick");
        for (IBankAccount account : BankAPI.getApi().GetAllBankAccounts(false)) {
            account.tick();
        }
        filler.pop();
    }

    @SubscribeEvent
    public static void playerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (IBankAccount account : BankAPI.getApi().GetAllBankAccounts(false)) {
                account.onPlayerJoined(player2);
            }
        }
    }

    @SubscribeEvent
    public static void treeGrowEvent(BlockGrowFeatureEvent event) {
        try {
            Feature feature;
            Holder holder = event.getFeature();
            if (holder != null && (feature = ((ConfiguredFeature)holder.value()).feature()) instanceof AbstractHugeMushroomFeature) {
                AbstractHugeMushroomFeature feature2 = (AbstractHugeMushroomFeature)feature;
                LevelAccessor level = event.getLevel();
                BlockPos center = event.getPos();
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                int radius = 3;
                int height = 13;
                for (int y = 0; y <= 13; ++y) {
                    for (int x = -3; x <= 3; ++x) {
                        for (int z = -3; z <= 3; ++z) {
                            pos.setWithOffset((Vec3i)center, x, y, z);
                            BlockState state = level.getBlockState((BlockPos)pos);
                            if (!BlockProtectionHelper.ShouldProtect(state, level.getBlockEntity((BlockPos)pos))) continue;
                            LightmansCurrency.LogInfo("Protected block detected at " + pos.toShortString() + " which is within the potential growth area of a " + feature2.getClass().getName() + " attempting to grow at " + center.toShortString() + "\nGrowth will be cancelled!");
                            event.setCanceled(true);
                            return;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        ItemStack heldItem = player.getItemInHand(event.getHand());
        if (InventoryUtil.ItemHasTag(heldItem, LCTags.Items.VARIANT_WANDS) && IVariantBlock.tryUseWand(player, event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerUseItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        ItemStack heldItem = player.getItemInHand(event.getHand());
        if (InventoryUtil.ItemHasTag(heldItem, LCTags.Items.VARIANT_WANDS)) {
            player.openMenu(ItemVariantSelectMenu.providerFor());
        }
    }
}

