/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common;

import io.github.lightman314.lightmanscurrency.LCRegistries;
import io.github.lightman314.lightmanscurrency.api.capability.money.CapabilityMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.capability.money.CapabilityMoneyViewer;
import io.github.lightman314.lightmanscurrency.api.capability.variant.CapabilityVariantData;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.CapabilityInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.util.BlockEntityBlockHelper;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.items.cards.ATMCardMoneyHandler;
import io.github.lightman314.lightmanscurrency.common.items.cards.PrepaidCardMoneyHandler;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;

@EventBusSubscriber(modid="lightmanscurrency")
public class ModEventHandler {
    @SubscribeEvent
    private static void registerRegistries(NewRegistryEvent event) {
        event.register(LCRegistries.EJECTION_DATA);
        event.register(LCRegistries.CUSTOM_DATA);
    }

    @SubscribeEvent
    private static void registerCapabilityProviders(RegisterCapabilitiesEvent event) {
        TraderBlockEntity.easyRegisterCapProvider(event, Capabilities.ItemHandler.BLOCK, (t, s) -> {
            if (t instanceof ItemTraderData) {
                ItemTraderData itemTrader = (ItemTraderData)t;
                return itemTrader.getItemHandler((Direction)s);
            }
            return null;
        }, BlockEntityBlockHelper.getBlocksForBlockEntities(BlockEntityBlockHelper.ITEM_TRADER_TYPE, BlockEntityBlockHelper.FREEZER_TRADER_TYPE, BlockEntityBlockHelper.ARMOR_TRADER_TYPE, BlockEntityBlockHelper.TICKET_KIOSK_TYPE, BlockEntityBlockHelper.BOOKSHELF_TRADER_TYPE));
        TraderBlockEntity.easyRegisterCapProvider(event, Capabilities.ItemHandler.BLOCK, (t, s) -> {
            if (t instanceof SlotMachineTraderData) {
                SlotMachineTraderData slotMachine = (SlotMachineTraderData)t;
                return slotMachine.getItemHandler((Direction)s);
            }
            return null;
        }, ModBlocks.SLOT_MACHINE.get());
        TraderBlockEntity.easyRegisterCapProvider(event, Capabilities.ItemHandler.BLOCK, (t, s) -> {
            if (t instanceof GachaTrader) {
                GachaTrader gachaMachine = (GachaTrader)t;
                return gachaMachine.getItemHandler((Direction)s);
            }
            return null;
        }, BlockEntityBlockHelper.getBlocksForBlockEntity(BlockEntityBlockHelper.GACHA_MACHINE_TYPE));
        CapabilityInterfaceBlockEntity.easyRegisterCapProvider(event, Capabilities.ItemHandler.BLOCK);
        IRotatableBlock.registerRotatableCapability(event, Capabilities.ItemHandler.BLOCK, ModBlockEntities.TRADER_INTERFACE_ITEM.get(), (be, relativeSide) -> be.getItemHandler().getHandler((Direction)relativeSide));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntities.COIN_CHEST.get(), (be, direction) -> be.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntities.COIN_JAR.get(), (b, s) -> b.getViewer());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntities.COIN_MINT.get(), (mint, side) -> mint.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntities.MONEY_BAG.get(), (b, s) -> b.viewer);
        event.registerItem(CapabilityMoneyViewer.MONEY_VIEWER_ITEM, (stack, c) -> WalletItem.getDataWrapper(stack), new ItemLike[]{(ItemLike)ModItems.WALLET_COPPER.get(), (ItemLike)ModItems.WALLET_IRON.get(), (ItemLike)ModItems.WALLET_GOLD.get(), (ItemLike)ModItems.WALLET_EMERALD.get(), (ItemLike)ModItems.WALLET_DIAMOND.get(), (ItemLike)ModItems.WALLET_NETHERITE.get(), (ItemLike)ModItems.WALLET_NETHER_STAR.get()});
        event.registerEntity(CapabilityMoneyHandler.MONEY_HANDLER_ENTITY, EntityType.PLAYER, (player, c) -> MoneyAPI.getApi().GetPlayersMoneyHandler((Player)player));
        event.registerEntity(CapabilityMoneyViewer.MONEY_VIEWER_ENTITY, EntityType.PLAYER, (player, c) -> MoneyAPI.getApi().GetPlayersMoneyHandler((Player)player));
        event.registerItem(CapabilityMoneyHandler.MONEY_HANDLER_ITEM, (stack, c) -> new ATMCardMoneyHandler((ItemStack)stack), new ItemLike[]{(ItemLike)ModItems.ATM_CARD.get()});
        event.registerItem(CapabilityMoneyHandler.MONEY_HANDLER_ITEM, (stack, c) -> new PrepaidCardMoneyHandler((ItemStack)stack), new ItemLike[]{(ItemLike)ModItems.PREPAID_CARD.get()});
        CapabilityVariantData.registerNormalBlock(event, ModBlocks.TERMINAL.get(), ModBlocks.GEM_TERMINAL.get());
        CapabilityVariantData.registerLCMultiBlock(event, ModBlocks.ATM.get());
    }
}

