/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.ICapabilityBlock;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.util.BlockEntityBlockHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class CapabilityInterfaceBlockEntity
extends BlockEntity
implements IVariantDataStorage {
    public CapabilityInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CAPABILITY_INTERFACE.get(), pos, state);
    }

    public static <T, C> void easyRegisterCapProvider(@Nonnull RegisterCapabilitiesEvent event, @Nonnull BlockCapability<T, C> capability) {
        event.registerBlock(capability, (level, pos, state, be, context) -> {
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof ICapabilityBlock) {
                ICapabilityBlock handlerBlock = (ICapabilityBlock)patt0$temp;
                BlockPos newPos = handlerBlock.getCapabilityBlockPos(state, (LevelAccessor)level, pos);
                if (newPos.equals((Object)pos) || level.getBlockEntity(newPos) instanceof CapabilityInterfaceBlockEntity) {
                    return null;
                }
                return level.getCapability(capability, newPos, context);
            }
            return null;
        }, BlockEntityBlockHelper.getBlocksForBlockEntities(BlockEntityBlockHelper.CAPABILITY_INTERFACE_TYPE));
    }

    @Override
    @Nullable
    public ResourceLocation getCurrentVariant() {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.tryRunOnCoreBlockEntity(be -> {
            if (be instanceof IVariantDataStorage) {
                IVariantDataStorage data = (IVariantDataStorage)be;
                result.set(data.getCurrentVariant());
            }
        });
        return result.get();
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant) {
        this.tryRunOnCoreBlockEntity(be -> {
            if (be instanceof IVariantDataStorage) {
                IVariantDataStorage data = (IVariantDataStorage)be;
                data.setVariant(variant);
            }
        });
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant, boolean locked) {
        this.tryRunOnCoreBlockEntity(be -> {
            if (be instanceof IVariantDataStorage) {
                IVariantDataStorage data = (IVariantDataStorage)be;
                data.setVariant(variant, locked);
            }
        });
    }

    @Override
    public boolean isVariantLocked() {
        AtomicBoolean result = new AtomicBoolean(false);
        this.tryRunOnCoreBlockEntity(be -> {
            IVariantDataStorage data = IVariantDataStorage.get(be);
            if (data != null) {
                result.set(data.isVariantLocked());
            }
        });
        return result.get();
    }

    @Nullable
    public final BlockEntity tryGetCoreBlockEntity() {
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof ICapabilityBlock) {
            ICapabilityBlock block2 = (ICapabilityBlock)block;
            BlockPos newPos = block2.getCapabilityBlockPos(state, (LevelAccessor)this.level, this.worldPosition);
            if (newPos.equals((Object)this.worldPosition)) {
                return null;
            }
            BlockEntity be = this.level.getBlockEntity(newPos);
            if (be instanceof CapabilityInterfaceBlockEntity) {
                return null;
            }
            return be;
        }
        return null;
    }

    public final void tryRunOnCoreBlockEntity(Consumer<BlockEntity> consumer) {
        BlockEntity be = this.tryGetCoreBlockEntity();
        if (be != null) {
            consumer.accept(be);
        }
    }

    public void onLoad() {
        BlockState state;
        if (this.getCurrentVariant() != null && VariantProvider.getVariantBlock((state = this.getBlockState()).getBlock()) != null && !((Boolean)state.getValue((Property)IVariantBlock.VARIANT)).booleanValue()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(true)));
        }
        super.onLoad();
    }
}

