/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.MoneyBagItemViewer;
import io.github.lightman314.lightmanscurrency.common.blocks.MoneyBagBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.data.types.LootTableEntry;
import io.github.lightman314.lightmanscurrency.common.items.data.MoneyBagData;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Range;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MoneyBagBlockEntity
extends EasyBlockEntity
implements IServerTicker {
    public static final int MAX_ITEM_COUNT = 576;
    public boolean shouldDropItem = true;
    private Component customName = null;
    private boolean lootTableChecked = false;
    private BlockPos savedPosition;
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed = -1L;
    private final List<ItemStack> contents = new ArrayList<ItemStack>();
    public final IItemHandler viewer = new MoneyBagItemViewer(this);

    public MoneyBagBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        this(ModBlockEntities.MONEY_BAG.get(), pos, state);
    }

    protected MoneyBagBlockEntity(@Nonnull BlockEntityType<?> type, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        super(type, pos, state);
    }

    public List<ItemStack> viewContents() {
        return InventoryUtil.copyList(this.contents);
    }

    public List<ItemStack> clearContents() {
        this.checkLootTable();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(this.contents);
        this.contents.clear();
        this.setChanged();
        return result;
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public @Range(from=0L, to=3L) int getBlockSize() {
        return MoneyBagBlockEntity.getBlockSize(this.getTotalContentCount());
    }

    public static @Range(from=0L, to=3L) int getBlockSize(List<ItemStack> contents) {
        return MoneyBagBlockEntity.getBlockSize(MoneyBagBlockEntity.getTotalContentCount(contents));
    }

    public static @Range(from=0L, to=3L) int getBlockSize(int totalCount) {
        if (totalCount < 192) {
            return 0;
        }
        if (totalCount < 384) {
            return 1;
        }
        if (totalCount < 576) {
            return 2;
        }
        return 3;
    }

    public int getTotalContentCount() {
        return MoneyBagBlockEntity.getTotalContentCount(this.contents);
    }

    public static int getTotalContentCount(List<ItemStack> contents) {
        int count = 0;
        for (ItemStack item : contents) {
            count += item.getCount();
        }
        return count;
    }

    public boolean tryInsertItem(ItemStack item, @Nullable Player player) {
        this.checkLootTable();
        if (this.getTotalContentCount() >= 576) {
            return false;
        }
        if (CoinAPI.getApi().IsAllowedInCoinContainer(item, false)) {
            for (ItemStack i : this.contents) {
                if (!InventoryUtil.ItemMatches(i, item)) continue;
                i.grow(1);
                this.onContentsChanged();
                return true;
            }
            this.contents.add(item.copyWithCount(1));
            this.onContentsChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeRandomItem() {
        this.checkLootTable();
        ItemStack result = MoneyBagBlockEntity.removeRandomItem(this.contents, this.level.random);
        if (!result.isEmpty()) {
            this.onContentsChanged();
        }
        return result;
    }

    public static ItemStack removeRandomItem(List<ItemStack> contents, RandomSource random) {
        if (contents.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int totalCount = 0;
        for (ItemStack item : contents) {
            totalCount += item.getCount();
        }
        int rand = random.nextInt(totalCount);
        for (int i = 0; i < contents.size(); ++i) {
            ItemStack item = contents.get(i);
            if ((rand -= item.getCount()) >= 0) continue;
            ItemStack result = item.split(1);
            if (item.isEmpty()) {
                contents.remove(i);
            }
            return result;
        }
        return ItemStack.EMPTY;
    }

    private void onContentsChanged() {
        if (this.isClient()) {
            return;
        }
        this.setChanged();
        BlockEntityUtil.sendUpdatePacket(this);
        BlockState state = this.getBlockState();
        int currentSize = (Integer)state.getValue((Property)MoneyBagBlock.SIZE);
        int actualSize = this.getBlockSize();
        if (currentSize != actualSize) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)MoneyBagBlock.SIZE, (Comparable)Integer.valueOf(actualSize)));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)lookup));
        }
        ListTag list = new ListTag();
        for (ItemStack item : new ArrayList<ItemStack>(this.contents)) {
            if (item.isEmpty()) continue;
            list.add((Object)InventoryUtil.saveItemNoLimits(item, lookup));
        }
        tag.put("Contents", (Tag)list);
        if (this.lootTable != null) {
            tag.putString("LootTable", this.lootTable.location().toString());
            if (this.lootTableSeed >= 0L) {
                tag.putLong("LootTableSeed", this.lootTableSeed);
            }
            tag.put("SavedPos", (Tag)TagUtil.saveBlockPos(this.savedPosition == null ? this.worldPosition : this.savedPosition));
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)lookup);
        }
        this.contents.clear();
        ListTag list = tag.getList("Contents", 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = InventoryUtil.loadItemNoLimits(list.getCompound(i), lookup);
            if (item.isEmpty()) continue;
            this.contents.add(item);
        }
        if (tag.contains("LootTable")) {
            this.lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)VersionUtil.parseResource(tag.getString("LootTable")));
            if (tag.contains("LootTableSeed")) {
                this.lootTableSeed = tag.getLong("LootTableSeed");
            }
            if (tag.contains("SavedPos")) {
                this.savedPosition = TagUtil.loadBlockPos(tag.getCompound("SavedPos"));
            }
        }
    }

    public void loadFromItem(ItemStack moneybag) {
        this.setComponents(DataComponentMap.EMPTY);
        if (moneybag.has(DataComponents.CUSTOM_NAME)) {
            this.customName = (Component)moneybag.get(DataComponents.CUSTOM_NAME);
        }
        MoneyBagData data = (MoneyBagData)moneybag.getOrDefault(ModDataComponents.MONEY_BAG_CONTENTS, (Object)MoneyBagData.EMPTY);
        this.contents.clear();
        this.contents.addAll(InventoryUtil.copyList(data.contents()));
        this.onContentsChanged();
        if (moneybag.has(ModDataComponents.LOOT_TABLE_ENTRY)) {
            LootTableEntry tableEntry = (LootTableEntry)moneybag.get(ModDataComponents.LOOT_TABLE_ENTRY);
            this.lootTable = tableEntry.lootTable();
            this.lootTableSeed = tableEntry.seed();
            this.savedPosition = this.worldPosition;
            this.setChanged();
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.isClient()) {
            BlockEntityUtil.requestUpdatePacket(this);
        } else {
            this.checkLootTable();
        }
    }

    @Override
    public void serverTick() {
        if (!this.lootTableChecked) {
            this.checkLootTable();
        }
    }

    private void checkLootTable() {
        if (this.lootTableChecked) {
            return;
        }
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (this.lootTable != null && this.savedPosition != null) {
                this.lootTableChecked = true;
                if (this.savedPosition.equals((Object)this.worldPosition)) {
                    return;
                }
                RegistryAccess lookup = this.level.registryAccess();
                LootTable table = (LootTable)lookup.registryOrThrow(Registries.LOOT_TABLE).get(this.lootTable);
                if (table == null) {
                    this.lootTable = null;
                    this.lootTableSeed = -1L;
                    this.savedPosition = null;
                }
                LootParams lootParams = new LootParams.Builder(sl).withParameter(LootContextParams.ORIGIN, (Object)this.worldPosition.getCenter()).create(LootContextParamSets.CHEST);
                this.contents.clear();
                ObjectArrayList loot = this.lootTableSeed >= 0L ? table.getRandomItems(lootParams, this.lootTableSeed) : table.getRandomItems(lootParams);
                this.contents.addAll(InventoryUtil.combineQueryItems((List<ItemStack>)loot));
                this.lootTable = null;
                this.lootTableSeed = -1L;
                this.savedPosition = null;
                this.onContentsChanged();
            }
        }
    }

    public void copyContentsTo(ItemStack item) {
        if (this.customName != null) {
            item.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
        }
        if (!this.contents.isEmpty()) {
            MoneyBagData data = new MoneyBagData((List<ItemStack>)ImmutableList.copyOf(this.viewContents()), this.getBlockSize());
            item.set(ModDataComponents.MONEY_BAG_CONTENTS, (Object)data);
        }
        if (this.lootTable != null) {
            item.set(ModDataComponents.LOOT_TABLE_ENTRY, (Object)new LootTableEntry(this.lootTable, this.lootTableSeed));
        }
    }
}

