/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IBookTraderBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataBook;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BookTraderBlockEntity
extends ItemTraderBlockEntity {
    public BookTraderBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BOOK_TRADER.get(), pos, state);
    }

    public BookTraderBlockEntity(BlockPos pos, BlockState state, int count) {
        super(ModBlockEntities.BOOK_TRADER.get(), pos, state, count);
    }

    @Override
    @Nonnull
    public ItemTraderData buildNewTrader() {
        return new ItemTraderDataBook(this.tradeCount, this.level, this.worldPosition);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3f GetBookRenderPos(int tradeSlot) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof IBookTraderBlock) {
            IBookTraderBlock block2 = (IBookTraderBlock)block;
            return block2.GetBookRenderPos(tradeSlot, this.getBlockState());
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternionf> GetBookRenderRot(int tradeSlot) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof IBookTraderBlock) {
            IBookTraderBlock block2 = (IBookTraderBlock)block;
            return block2.GetBookRenderRot(tradeSlot, this.getBlockState());
        }
        return new ArrayList<Quaternionf>();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float GetBookRenderScale(int tradeSlot) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof IBookTraderBlock) {
            IBookTraderBlock block2 = (IBookTraderBlock)block;
            return block2.GetBookRenderScale(tradeSlot, this.getBlockState());
        }
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof IBookTraderBlock) {
            IBookTraderBlock block2 = (IBookTraderBlock)block;
            return block2.maxRenderIndex();
        }
        return 0;
    }
}

