/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.api.misc.IClientTicker;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;

public class FreezerTraderBlockEntity
extends ItemTraderBlockEntity
implements IClientTicker {
    private float doorAngle;
    private float prevDoorAngle;

    public FreezerTraderBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FREEZER_TRADER.get(), pos, state);
    }

    public FreezerTraderBlockEntity(BlockPos pos, BlockState state, int tradeCount) {
        super(ModBlockEntities.FREEZER_TRADER.get(), pos, state, tradeCount);
    }

    public float getDoorAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevDoorAngle, (float)this.doorAngle);
    }

    @Override
    public void clientTick() {
        Object trader = this.getTraderData();
        if (trader != null) {
            int userCount = ((TraderData)trader).getUserCount();
            this.prevDoorAngle = this.doorAngle;
            if (userCount > 0 && this.doorAngle == 0.0f) {
                this.level.playLocalSound((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
            }
            if (userCount > 0 && this.doorAngle < 1.0f) {
                this.doorAngle += 0.1f;
            } else if (userCount <= 0 && this.doorAngle > 0.0f) {
                this.doorAngle -= 0.1f;
                if (this.doorAngle < 0.5f && this.prevDoorAngle >= 0.5f) {
                    this.level.playLocalSound((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                }
            }
            if (this.doorAngle > 1.0f) {
                this.doorAngle = 1.0f;
            } else if (this.doorAngle < 0.0f) {
                this.doorAngle = 0.0f;
            }
        }
    }
}

