/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettings;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsHolder;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.OutputConflictHandling;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PaygateBlockEntity
extends TraderBlockEntity<PaygateTraderData> {
    private final Map<Direction, SidedData> data = new HashMap<Direction, SidedData>();
    private final Map<Direction, Integer> simplifiedData = new HashMap<Direction, Integer>();

    public boolean allowOutputSide(Direction side) {
        return this.data.containsKey(side);
    }

    public PaygateBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntities.PAYGATE.get(), pos, state);
    }

    protected PaygateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    protected PaygateTraderData castOrNullify(@Nonnull TraderData trader) {
        if (trader instanceof PaygateTraderData) {
            PaygateTraderData pg = (PaygateTraderData)trader;
            return pg;
        }
        return null;
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        super.saveAdditional(compound, lookup);
        this.saveRedstoneData(compound);
    }

    public final void saveRedstoneData(CompoundTag compound) {
        CompoundTag dataTag = new CompoundTag();
        this.data.forEach((side, data) -> dataTag.put(side.toString(), (Tag)data.save()));
        compound.put("OutputData", (Tag)dataTag);
    }

    public final CompoundTag saveSimpleTimerData() {
        CompoundTag compound = new CompoundTag();
        CompoundTag dataTag = new CompoundTag();
        this.data.forEach((side, data) -> dataTag.putInt(side.toString(), data.timer));
        compound.put("SimpleTimer", (Tag)dataTag);
        return compound;
    }

    @Override
    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        if (compound.contains("Timer", 3)) {
            int timer = compound.getInt("Timer");
            DirectionalSettings sides = new DirectionalSettings(new DummyHolder());
            int power = 15;
            if (compound.contains("OutputSides") && compound.contains("Power")) {
                sides.load(compound, "OutputSides");
                power = compound.getInt("Power");
            } else {
                for (Direction side : Direction.values()) {
                    sides.setState(side, DirectionalSettingsState.OUTPUT);
                }
            }
            this.data.clear();
            for (Direction side : Direction.values()) {
                if (!sides.allowOutputs(side)) continue;
                this.data.put(side, new SidedData(power, timer, ""));
            }
        }
        if (compound.contains("OutputData")) {
            this.data.clear();
            CompoundTag data = compound.getCompound("OutputData");
            for (Direction side : Direction.values()) {
                if (!data.contains(side.toString())) continue;
                this.data.put(side, SidedData.load(data.getCompound(side.toString())));
            }
        } else if (compound.contains("SimpleTimer")) {
            this.simplifiedData.clear();
            CompoundTag data = compound.getCompound("SimpleTimer");
            for (Direction side : Direction.values()) {
                if (!data.contains(side.toString())) continue;
                this.simplifiedData.put(side, data.getInt(side.toString()));
            }
        }
        super.loadAdditional(compound, lookup);
    }

    public static List<OutputVisibilityData> parseVisibilityData(CompoundTag dataTag) {
        HashMap<Direction, SidedData> data = new HashMap<Direction, SidedData>();
        for (Direction side : Direction.values()) {
            if (!dataTag.contains(side.toString())) continue;
            data.put(side, SidedData.load(dataTag.getCompound(side.toString())));
        }
        HashMultimap temp = HashMultimap.create();
        data.forEach((arg_0, arg_1) -> PaygateBlockEntity.lambda$parseVisibilityData$2((Multimap)temp, arg_0, arg_1));
        ArrayList<OutputVisibilityData> results = new ArrayList<OutputVisibilityData>();
        temp.asMap().forEach((d, sides) -> results.add(new OutputVisibilityData((List<Direction>)ImmutableList.copyOf((Collection)sides), d.name, d.power, d.timer)));
        results.sort(Comparator.comparingInt(OutputVisibilityData::partialHash));
        return results;
    }

    public boolean isActive() {
        return this.isClient() ? !this.simplifiedData.isEmpty() : !this.data.isEmpty();
    }

    public List<Direction> getActiveSides() {
        return this.isClient() ? new ArrayList<Direction>(this.simplifiedData.keySet()) : new ArrayList<Direction>(this.data.keySet());
    }

    public int getTimeRemaining(DirectionalSettings sides) {
        AtomicInteger time = new AtomicInteger(0);
        if (this.isClient()) {
            this.simplifiedData.forEach((side, timer) -> {
                if (sides.allowOutputs((Direction)side)) {
                    time.set(Math.max(time.get(), timer));
                }
            });
        } else {
            this.data.forEach((side, data) -> {
                if (sides.allowOutputs((Direction)side)) {
                    time.set(Math.max(time.get(), data.timer));
                }
            });
        }
        return time.get();
    }

    public int getPowerLevel(Direction relativeSide) {
        if (this.data.containsKey(relativeSide)) {
            return this.data.get((Object)relativeSide).powerLevel;
        }
        return 0;
    }

    public void activate(int duration, int level, DirectionalSettings outputSides, OutputConflictHandling conflictHandling, String name) {
        for (Direction side : Direction.values()) {
            if (!outputSides.allowOutputs(side)) continue;
            int newTime = duration;
            if (this.data.containsKey(side) && conflictHandling == OutputConflictHandling.ADD_TIME) {
                newTime += this.data.get((Object)side).timer;
            }
            this.data.put(side, new SidedData(level, newTime, name));
        }
        this.level.setBlock(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(true)), 2);
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        this.markTimerDirty();
    }

    @Override
    public void serverTick() {
        super.serverTick();
        boolean changed = false;
        boolean removalChanged = false;
        for (Direction side : new ArrayList<Direction>(this.data.keySet())) {
            changed = true;
            if (!this.data.get(side).tickTimer()) continue;
            this.data.remove(side);
            removalChanged = true;
        }
        if (changed) {
            this.markTimerDirty();
        }
        if (removalChanged) {
            if (this.data.isEmpty()) {
                this.level.setBlock(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(false)), 2);
            }
            this.level.updateNeighborsAt(this.worldPosition, this.level.getBlockState(this.worldPosition).getBlock());
        }
    }

    public void markTimerDirty() {
        this.setChanged();
        if (!this.level.isClientSide) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveSimpleTimerData());
        }
    }

    public int getValidTicketTrade(Player player, ItemStack heldItem) {
        long ticketID;
        PaygateTraderData trader = (PaygateTraderData)this.getTraderData();
        if (TicketItem.isTicketOrPass(heldItem) && (ticketID = TicketItem.GetTicketID(heldItem)) >= -1L) {
            TradeContext context = TradeContext.create((TraderData)trader, player, false).build();
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                PaygateTradeData trade = trader.getTrade(i);
                if (!trade.isTicketTrade() || trade.getTicketID() != ticketID || trader.runPreTradeEvent(trade, context).isCanceled()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    @Nonnull
    protected PaygateTraderData buildNewTrader() {
        return new PaygateTraderData(this.level, this.worldPosition);
    }

    private static /* synthetic */ void lambda$parseVisibilityData$2(Multimap temp, Direction side, SidedData d) {
        temp.put((Object)new OutputDataKey(d.powerLevel, d.timer, d.name), (Object)side);
    }

    private static class DummyHolder
    implements IDirectionalSettingsHolder {
        private DummyHolder() {
        }

        @Override
        public boolean allowInputs() {
            return false;
        }
    }

    private static class SidedData {
        private final int powerLevel;
        private int timer;
        private final String name;

        private SidedData(int power, int timer, @Nullable String name) {
            this.powerLevel = power;
            this.timer = timer;
            this.name = name == null || name.isBlank() ? null : name;
        }

        boolean tickTimer() {
            return --this.timer <= 0;
        }

        CompoundTag save() {
            CompoundTag entry = new CompoundTag();
            entry.putInt("Power", this.powerLevel);
            entry.putInt("Timer", this.timer);
            if (this.name != null) {
                entry.putString("Name", this.name);
            }
            return entry;
        }

        static SidedData load(CompoundTag entry) {
            String name = null;
            if (entry.contains("Name")) {
                name = entry.getString("Name");
            }
            return new SidedData(entry.getInt("Power"), entry.getInt("Timer"), name);
        }
    }

    public record OutputVisibilityData(List<Direction> sides, @Nullable String name, int power, int timer) {
        int partialHash() {
            return Objects.hash(this.sides, this.name, this.power);
        }
    }

    private record OutputDataKey(int power, int timer, String name) {
    }
}

