/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EasyBlock
extends Block {
    public EasyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        EasyBlock easyBlock = this;
        if (easyBlock instanceof IVariantBlock) {
            IVariantBlock vb = (IVariantBlock)((Object)easyBlock);
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        EasyBlock easyBlock = this;
        if (easyBlock instanceof IVariantBlock) {
            IVariantBlock vb = (IVariantBlock)((Object)easyBlock);
            builder.add(new Property[]{IVariantBlock.VARIANT});
        }
    }

    protected boolean isBlockOpaque(BlockState state) {
        return this.isBlockOpaque();
    }

    protected boolean isBlockOpaque() {
        return true;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (this instanceof IVariantBlock && ((Boolean)state.getValue((Property)IVariantBlock.VARIANT)).booleanValue()) {
            return Shapes.empty();
        }
        if (this.isBlockOpaque(state)) {
            return super.getOcclusionShape(state, level, pos);
        }
        return Shapes.empty();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        EasyBlock easyBlock;
        ItemStack result = super.getCloneItemStack(state, target, level, pos, player);
        if (player.isCrouching() && (easyBlock = this) instanceof IVariantBlock) {
            IVariantBlock vb = (IVariantBlock)((Object)easyBlock);
            IVariantBlock.copyDataToItem(IVariantDataStorage.get((BlockGetter)level, pos), result);
        }
        return result;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryCopyVariant(level, pos, stack);
    }

    protected final void tryCopyVariant(Level level, BlockPos pos, ItemStack stack) {
        if (level.isClientSide) {
            return;
        }
        if (this instanceof IVariantBlock) {
            IVariantBlock.copyDataFromItem(IVariantDataStorage.get((BlockGetter)level, pos), stack);
        }
    }
}

