/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.TradeIDArgument;
import io.github.lightman314.lightmanscurrency.common.playertrading.PlayerTrade;
import io.github.lightman314.lightmanscurrency.common.playertrading.PlayerTradeManager;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandPlayerTrading {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder requestTradeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lctrade").requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(CommandPlayerTrading::requestPlayerTrade));
        LiteralArgumentBuilder acceptTradeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lctradeaccept").requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"tradeID", (ArgumentType)TradeIDArgument.argument()).executes(CommandPlayerTrading::acceptPlayerTrade));
        dispatcher.register(requestTradeCommand);
        dispatcher.register(acceptTradeCommand);
    }

    private static int requestPlayerTrade(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer host = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerPlayer guest = EntityArgument.getPlayer(context, (String)"player");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (guest == host) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_TRADE_SELF.get(new Object[0]));
            return 0;
        }
        int tradeID = PlayerTradeManager.CreateNewTrade(host, guest);
        host.sendSystemMessage((Component)LCText.COMMAND_TRADE_HOST_NOTIFY.get(guest.getName()));
        guest.sendSystemMessage((Component)LCText.COMMAND_TRADE_GUEST_NOTIFY.get(host.getName(), LCText.COMMAND_TRADE_GUEST_NOTIFY_PROMPT.getWithStyle(ChatFormatting.BOLD, ChatFormatting.GREEN).withStyle(s -> s.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lctradeaccept " + tradeID)))).withStyle(ChatFormatting.GOLD));
        return 1;
    }

    private static int acceptPlayerTrade(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer guest = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        int tradeID = TradeIDArgument.getTradeID(context, "tradeID");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerTrade trade = PlayerTradeManager.GetTrade(tradeID);
        if (trade != null && trade.isGuest((Player)guest)) {
            int rangeResult = trade.isGuestInRange(guest);
            if (rangeResult > 0) {
                TextEntry entry;
                switch (rangeResult) {
                    case 1: {
                        TextEntry textEntry = LCText.COMMAND_TRADE_ACCEPT_FAIL_OFFLINE;
                        break;
                    }
                    case 2: {
                        TextEntry textEntry = LCText.COMMAND_TRADE_ACCEPT_FAIL_DISTANCE;
                        break;
                    }
                    case 3: {
                        TextEntry textEntry = LCText.COMMAND_TRADE_ACCEPT_FAIL_DIMENSION;
                        break;
                    }
                    default: {
                        TextEntry textEntry = entry = null;
                    }
                }
                if (entry != null) {
                    EasyText.sendCommandFail(source, (Component)entry.get(PlayerTrade.enforceDistance()));
                }
                return 0;
            }
            if (trade.requestAccepted(guest)) {
                return 1;
            }
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_TRADE_ACCEPT_ERROR.get(new Object[0]));
            return 0;
        }
        EasyText.sendCommandFail(source, (Component)LCText.COMMAND_TRADE_ACCEPT_NOT_FOUND.get(new Object[0]));
        return 0;
    }
}

