/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeTypes;
import io.github.lightman314.lightmanscurrency.common.crafting.durability.DurabilityData;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface TicketStationRecipe
extends Recipe<TicketStationRecipeInput> {
    public static final Predicate<String> CODE_PREDICATE = s -> {
        if (s.isBlank()) {
            return false;
        }
        if (s.length() > 16) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (TicketStationRecipe.validCodeChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    };
    public static final Predicate<String> CODE_INPUT_PREDICATE = s -> s.isEmpty() || CODE_PREDICATE.test((String)s);

    public static boolean validCodeChar(char codeChar) {
        return codeChar >= 'a' && codeChar <= 'z' || codeChar >= 'A' && codeChar <= 'Z' || codeChar >= '0' && codeChar <= '9';
    }

    default public RecipeType<TicketStationRecipe> getType() {
        return RecipeTypes.TICKET.get();
    }

    default public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.TICKET_STATION.get());
    }

    public static List<ItemStack> exampleModifierList(TagKey<Item> tag, Item ... extra) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Item extraItem : extra) {
            result.add(new ItemStack((ItemLike)extraItem));
        }
        for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(tag)) {
            result.add(new ItemStack((ItemLike)item.value()));
        }
        return result;
    }

    public static List<ItemStack> exampleTicketList(Supplier<? extends ItemLike> item) {
        return TicketStationRecipe.exampleTicketList(item.get().asItem());
    }

    public static List<ItemStack> exampleTicketList(Ingredient ingredient) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack item : ingredient.getItems()) {
            result.addAll(TicketStationRecipe.exampleTicketList(item.getItem()));
        }
        return result;
    }

    public static List<ItemStack> exampleTicketList(Item item) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Color color : Color.values()) {
            result.add(TicketItem.CreateExampleTicket(item, color));
        }
        return result;
    }

    public boolean consumeModifier();

    public boolean validModifier(ItemStack var1);

    public List<ItemStack> jeiModifierList();

    public boolean validIngredient(ItemStack var1);

    public Ingredient getIngredient();

    public ItemStack peekAtResult(Container var1, ExtraData var2);

    public ItemStack exampleResult();

    default public boolean validData(ExtraData data) {
        return this.validCode(data.code) && this.validDurability(data.durability);
    }

    default public boolean requiredCodeInput() {
        return false;
    }

    default public boolean validCode(String code) {
        return !this.requiredCodeInput() || CODE_PREDICATE.test(code);
    }

    default public boolean requiredDurabilityInput() {
        return this.getDurabilityData().isValid();
    }

    default public boolean validDurability(int durability) {
        return this.getDurabilityData().test(durability);
    }

    default public DurabilityData getDurabilityData() {
        return DurabilityData.NULL;
    }

    default public int validateDurability(int value, boolean roundUp) {
        DurabilityData data = this.getDurabilityData();
        if (!data.isValid()) {
            return value;
        }
        if (value > data.max) {
            value = data.max;
        }
        if (value < data.min) {
            value = data.allowInfinite && !roundUp ? 0 : data.min;
        }
        return value;
    }

    default public boolean matches(TicketStationRecipeInput container, Level level) {
        return this.validModifier(container.getItem(0)) && this.validIngredient(container.getItem(1));
    }

    default public boolean matchesTicketKioskSellItem(ItemStack sellItem) {
        return !this.consumeModifier() && this.validModifier(sellItem);
    }

    default public boolean allowIgnoreKioskRecipe() {
        return false;
    }

    public ItemStack assembleWithKiosk(ItemStack var1, ExtraData var2);

    default public ItemRequirement getKioskStorageRequirement(ItemStack sellItem) {
        return ItemRequirement.of(this.getIngredient(), sellItem.getCount());
    }

    public static StreamCodec<ByteBuf, Item> itemStreamCodec() {
        return ResourceLocation.STREAM_CODEC.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0));
    }

    public record ExtraData(String code, int durability) {
        public static final ExtraData EMPTY = new ExtraData("", 0);
    }
}

