/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data;

import io.github.lightman314.lightmanscurrency.LCRegistries;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@FieldsAreNonnullByDefault
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@EventBusSubscriber
public class CustomSaveData
extends SavedData {
    private static final Map<ResourceLocation, CustomData> serverDataCache = new HashMap<ResourceLocation, CustomData>();
    private final CustomData data;

    @Nullable
    public static <T extends CustomData> T getData(CustomDataType<T> type) {
        ResourceLocation dataID = LCRegistries.CUSTOM_DATA.getKey(type);
        if (dataID == null) {
            LightmansCurrency.LogError("Custom Data was not registered!");
            return null;
        }
        if (!serverDataCache.containsKey(dataID)) {
            LightmansCurrency.LogWarning("Attempted to get custom data '" + String.valueOf(dataID) + "' before the server started!", new Throwable());
            return null;
        }
        return (T)serverDataCache.get(dataID);
    }

    public static boolean isLoaded(CustomDataType<?> type) {
        ResourceLocation dataID = LCRegistries.CUSTOM_DATA.getKey(type);
        if (dataID == null) {
            return false;
        }
        return serverDataCache.containsKey(dataID);
    }

    private static void initServerData(MinecraftServer server) {
        ServerLevel overworld = server.overworld();
        if (overworld == null) {
            return;
        }
        serverDataCache.clear();
        LCRegistries.CUSTOM_DATA.forEach((T type) -> {
            ResourceLocation id = LCRegistries.CUSTOM_DATA.getKey(type);
            CustomSaveData data = (CustomSaveData)overworld.getDataStorage().computeIfAbsent(CustomSaveData.factory(type), type.fileName);
            serverDataCache.put(id, data.data);
        });
    }

    private CustomSaveData(CustomData data) {
        this.data = data;
        this.data.initServer(() -> ((CustomSaveData)this).setDirty());
    }

    private static SavedData.Factory<CustomSaveData> factory(CustomDataType<?> type) {
        return new SavedData.Factory(() -> new CustomSaveData((CustomData)type.create()), (t, l) -> {
            Object data = type.create();
            ((CustomData)data).loadData((CompoundTag)t, (HolderLookup.Provider)l);
            return new CustomSaveData((CustomData)data);
        });
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
        this.data.save(tag, lookup);
        return tag;
    }

    @SubscribeEvent
    private static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CustomSaveData.forEach(data -> data.onPlayerJoin(player2));
        }
    }

    @SubscribeEvent
    private static void onServerTick(ServerTickEvent.Pre event) {
        for (CustomData data : serverDataCache.values()) {
            Object ticker;
            if (data instanceof IEasyTickable) {
                ticker = (IEasyTickable)((Object)data);
                ticker.tick();
            }
            if (!(data instanceof IServerTicker)) continue;
            ticker = (IServerTicker)((Object)data);
            ticker.serverTick();
        }
    }

    @SubscribeEvent
    private static void onServerStart(ServerStartedEvent event) {
        CustomSaveData.initServerData(event.getServer());
    }

    @SubscribeEvent
    private static void onServerStop(ServerStoppedEvent event) {
        serverDataCache.clear();
    }

    private static void forEach(Consumer<CustomData> consumer) {
        serverDataCache.values().forEach(consumer);
    }
}

