/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CashRegisterItem
extends BlockItem {
    private static final SoundEvent soundEffect = SoundEvents.EXPERIENCE_ORB_PICKUP;

    public CashRegisterItem(Block block, Item.Properties properties) {
        super(block, properties.stacksTo(1));
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos lookPos = context.getClickedPos();
        Level level = context.getLevel();
        Block block = level.getBlockState(lookPos).getBlock();
        if (block instanceof ITraderBlock) {
            ITraderBlock block2 = (ITraderBlock)block;
            BlockEntity blockEntity = block2.getBlockEntity(level.getBlockState(lookPos), (LevelAccessor)level, lookPos);
            if (!this.HasEntity(context.getItemInHand(), blockEntity) && blockEntity instanceof TraderBlockEntity) {
                this.AddEntity(context.getItemInHand(), blockEntity);
                if (level.isClientSide) {
                    level.playSound(context.getPlayer(), blockEntity.getBlockPos(), soundEffect, SoundSource.NEUTRAL, 1.0f, 0.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof TraderBlockEntity) {
                if (level.isClientSide) {
                    level.playSound(context.getPlayer(), blockEntity.getBlockPos(), soundEffect, SoundSource.NEUTRAL, 1.0f, 1.35f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    private boolean HasEntity(ItemStack stack, BlockEntity blockEntity) {
        if (!stack.has(ModDataComponents.CASH_REGISTER_TRADER_POSITIONS)) {
            return false;
        }
        return ((List)stack.get(ModDataComponents.CASH_REGISTER_TRADER_POSITIONS)).stream().anyMatch(p -> p.equals((Object)blockEntity.getBlockPos()));
    }

    private void AddEntity(@Nonnull ItemStack stack, BlockEntity blockEntity) {
        ArrayList<BlockPos> editableList = new ArrayList<BlockPos>(CashRegisterItem.getNonnullData(stack));
        editableList.add(blockEntity.getBlockPos());
        stack.set(ModDataComponents.CASH_REGISTER_TRADER_POSITIONS, (Object)ImmutableList.copyOf(editableList));
    }

    @Nonnull
    public static List<BlockPos> getNonnullData(@Nonnull ItemStack stack) {
        return stack.has(ModDataComponents.CASH_REGISTER_TRADER_POSITIONS) ? (List)stack.get(ModDataComponents.CASH_REGISTER_TRADER_POSITIONS) : new ArrayList();
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        List<BlockPos> data = CashRegisterItem.getNonnullData(stack);
        tooltip.addAll(LCText.TOOLTIP_CASH_REGISTER.get(new Object[0]));
        tooltip.add((Component)LCText.TOOLTIP_CASH_REGISTER_INFO.get(data.size()));
        if (!Screen.hasShiftDown() || data.isEmpty()) {
            tooltip.add((Component)LCText.TOOLTIP_CASH_REGISTER_INSTRUCTIONS.get(new Object[0]));
        }
        if (Screen.hasShiftDown()) {
            for (int i = 0; i < data.size(); ++i) {
                BlockPos pos = data.get(i);
                tooltip.add((Component)LCText.TOOLTIP_CASH_REGISTER_DETAILS.get(i + 1, pos.getX(), pos.getY(), pos.getZ()));
            }
        } else if (!data.isEmpty()) {
            tooltip.add((Component)LCText.TOOLTIP_CASH_REGISTER_HOLD_SHIFT.get(new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
    }
}

