/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record ItemStackData(ItemStack stack) {
    public static final ItemStackData EMPTY = new ItemStackData(ItemStack.EMPTY);
    public static final Codec<ItemStackData> CODEC = ItemStack.OPTIONAL_CODEC.comapFlatMap(s -> DataResult.success((Object)new ItemStackData((ItemStack)s)), ItemStackData::stack);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackData> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.map(ItemStackData::new, ItemStackData::stack);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ItemStackData)) return false;
        ItemStackData other = (ItemStackData)obj;
        if (!InventoryUtil.ItemsFullyMatch(this.stack, other.stack)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ItemStack.hashItemAndComponents((ItemStack)this.stack), this.stack.getCount());
    }
}

