/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.data.register;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.api.codecs.LCCodecs;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class TransactionData {
    public static final Codec<TransactionType> TYPE_CODEC = EnumUtil.buildCodec(TransactionType.class, "Transaction Type");
    public static final Codec<TransactionData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LCCodecs.MONEY_VALUE.optionalFieldOf("amount").forGetter(TransactionData::optionalMoneyAmount), (App)Codec.DOUBLE.optionalFieldOf("mult").forGetter(TransactionData::optionalMultiplier), (App)TYPE_CODEC.fieldOf("type").forGetter(d -> d.type), (App)Codec.STRING.fieldOf("comment").forGetter(d -> d.comment), (App)LCCodecs.MONEY_VALUE.fieldOf("resultValue").forGetter(d -> d.resultValue)).apply((Applicative)builder, TransactionData::new));
    public static final StreamCodec<FriendlyByteBuf, TransactionData> STREAM_CODEC = StreamCodec.of((buffer, data) -> {
        Optional<MoneyValue> moneyArgument = data.optionalMoneyAmount();
        Optional<Double> multArgument = data.optionalMultiplier();
        buffer.writeBoolean(moneyArgument.isPresent());
        if (moneyArgument.isPresent()) {
            moneyArgument.get().encode((FriendlyByteBuf)buffer);
        } else if (multArgument.isPresent()) {
            buffer.writeDouble(multArgument.get().doubleValue());
        } else {
            throw new IllegalStateException("Somehow neither the Money Value OR Multiplier arguments are present!");
        }
        buffer.writeInt(data.type.ordinal());
        buffer.writeUtf(data.comment);
        data.resultValue.encode((FriendlyByteBuf)buffer);
    }, buffer -> {
        Either arg = buffer.readBoolean() ? Either.left((Object)MoneyValue.decode(buffer)) : Either.right((Object)buffer.readDouble());
        return new TransactionData((Either<MoneyValue, Double>)arg, (TransactionType)EnumUtil.enumFromOrdinal((int)buffer.readInt(), (Enum[])TransactionType.values(), (Enum)TransactionType.ADD), buffer.readUtf(), MoneyValue.decode(buffer));
    });
    public static final TransactionData EMPTY = new TransactionData((Either<MoneyValue, Double>)Either.left((Object)MoneyValue.empty()), TransactionType.ADD, "", MoneyValue.empty());
    public final Either<MoneyValue, Double> argument;
    public final TransactionType type;
    public final String comment;
    public final MoneyValue resultValue;

    private Optional<MoneyValue> optionalMoneyAmount() {
        AtomicReference<Object> h = new AtomicReference<Object>(null);
        this.argument.ifLeft(h::set);
        return Optional.ofNullable(h.get());
    }

    private Optional<Double> optionalMultiplier() {
        AtomicReference<Object> h = new AtomicReference<Object>(null);
        this.argument.ifRight(h::set);
        return Optional.ofNullable(h.get());
    }

    private TransactionData(Optional<MoneyValue> moneyArg, Optional<Double> multArg, TransactionType type, String comment, MoneyValue result) {
        this.argument = moneyArg.isPresent() ? Either.left((Object)moneyArg.get()) : Either.right((Object)multArg.orElse(1.0));
        this.type = type;
        this.comment = comment;
        this.resultValue = result;
    }

    private TransactionData(Either<MoneyValue, Double> argument, TransactionType type, String comment, MoneyValue result) {
        this.argument = argument;
        this.type = type;
        this.comment = comment;
        this.resultValue = result;
    }

    public boolean isValid() {
        return this.type.isValidArgument(this.argument);
    }

    public TransactionData withArgument(MoneyValue amount) {
        return new TransactionData((Either<MoneyValue, Double>)Either.left((Object)amount), this.type, this.comment, this.resultValue);
    }

    public TransactionData withArgument(double mult) {
        return new TransactionData((Either<MoneyValue, Double>)Either.right((Object)mult), this.type, this.comment, this.resultValue);
    }

    public TransactionData withType(TransactionType type) {
        Either newArg = this.argument;
        if (!type.isValidArgument(newArg)) {
            newArg = type.needsNumber ? Either.right((Object)1.0) : Either.left((Object)MoneyValue.empty());
        }
        return new TransactionData((Either<MoneyValue, Double>)newArg, type, this.comment, this.resultValue);
    }

    public TransactionData withComment(String comment) {
        return new TransactionData(this.argument, this.type, comment, this.resultValue);
    }

    public TransactionData calculateResult(MoneyValue currentBalance) {
        return new TransactionData(this.argument, this.type, this.comment, this.type.calculateResult(currentBalance, this.argument));
    }

    public static enum TransactionType {
        ADD(MoneyValue::addValue),
        SUBTRACT(MoneyValue::subtractValue),
        MULTIPLY(null, MoneyValue::multiplyValue);

        private final boolean needsNumber;
        private final BiFunction<MoneyValue, Either<MoneyValue, Double>, MoneyValue> calculation;

        public boolean isValidArgument(Either<MoneyValue, Double> argument) {
            AtomicBoolean result = new AtomicBoolean(false);
            argument.ifLeft(v -> result.set(!this.needsNumber)).ifRight(m -> result.set(this.needsNumber));
            return result.get();
        }

        public MoneyValue calculateResult(MoneyValue currentBalance, Either<MoneyValue, Double> argument) {
            return this.calculation.apply(currentBalance, argument);
        }

        private TransactionType(boolean needsNumber, BiFunction<MoneyValue, Either<MoneyValue, Double>, MoneyValue> calculation) {
            this.needsNumber = needsNumber;
            this.calculation = calculation;
        }

        private TransactionType(Void dummy, BiFunction<MoneyValue, Double, MoneyValue> calculation) {
            this(true, (MoneyValue old, Either<MoneyValue, Double> arg) -> {
                AtomicReference<MoneyValue> result = new AtomicReference<MoneyValue>((MoneyValue)old);
                arg.ifRight(mult -> result.set((MoneyValue)calculation.apply((MoneyValue)old, (Double)mult)));
                return result.get();
            });
        }

        private TransactionType(BiFunction<MoneyValue, MoneyValue, MoneyValue> calculation) {
            this(false, (MoneyValue old, Either<MoneyValue, Double> arg) -> {
                AtomicReference<MoneyValue> result = new AtomicReference<MoneyValue>((MoneyValue)old);
                arg.ifLeft(value -> result.set((MoneyValue)calculation.apply((MoneyValue)old, (MoneyValue)value)));
                return result.get();
            });
        }
    }
}

