/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot.glm;

import com.mojang.serialization.MapCodec;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.loot.LootManager;
import io.github.lightman314.lightmanscurrency.common.loot.tiers.ChestPoolLevel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;

public class CoinsInChestsModifier
implements IGlobalLootModifier {
    public static final CoinsInChestsModifier INSTANCE = new CoinsInChestsModifier();
    public static final MapCodec<CoinsInChestsModifier> SERIALIZER = MapCodec.unit((Object)new CoinsInChestsModifier());

    private CoinsInChestsModifier() {
        LightmansCurrency.LogInfo("CoinsInChestModifier was deserialized!");
    }

    @Nonnull
    public ObjectArrayList<ItemStack> apply(@Nonnull ObjectArrayList<ItemStack> generatedLoot, @Nonnull LootContext context) {
        if (!((Boolean)LCConfig.COMMON.enableChestLoot.get()).booleanValue()) {
            return generatedLoot;
        }
        String lootTable = context.getQueriedLootTableId().toString();
        ChestPoolLevel lootLevel = LootManager.GetChestPoolLevel(lootTable);
        if (lootLevel != null) {
            LightmansCurrency.LogDebug("Loot table '" + lootTable + "' has " + String.valueOf((Object)lootLevel) + " level chest loot. Adding coins to the spawned loot.");
            List<ItemStack> coinLoot = LootManager.getLoot(lootLevel.lootTable, context);
            for (ItemStack coin : coinLoot) {
                LightmansCurrency.LogDebug("Adding " + coin.getCount() + "x " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)coin.getItem())) + " to the chest loot.");
                generatedLoot.add((Object)coin);
            }
        }
        return generatedLoot;
    }

    @Nonnull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return SERIALIZER;
    }
}

