/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.upgrades.slot.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CoinChestMenu
extends LazyMessageMenu {
    public final CoinChestBlockEntity be;
    private final List<CoinSlot> coinSlots;
    private final List<UpgradeInputSlot> upgradeSlots;
    private final List<EasySlot> inventorySlots;
    private Consumer<LazyPacketData> extraHandler = d -> {};

    public CoinChestMenu(int id, Inventory inventory, CoinChestBlockEntity be) {
        super(ModMenus.COIN_CHEST.get(), id, inventory);
        this.be = be;
        this.be.startOpen(this.player);
        this.addValidator(BlockEntityValidator.of(be));
        this.addValidator(this.be::allowAccess);
        ArrayList<CoinSlot> cSlots = new ArrayList<CoinSlot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                CoinSlot s = new CoinSlot((Container)this.be.getStorage(), x + 9 * y, 8 + x * 18, 93 + y * 18, true);
                this.addSlot(s);
                cSlots.add(s);
            }
        }
        this.coinSlots = ImmutableList.copyOf(cSlots);
        ArrayList<UpgradeInputSlot> uSlots = new ArrayList<UpgradeInputSlot>();
        for (int y = 0; y < 3; ++y) {
            int index = y;
            UpgradeInputSlot s = new UpgradeInputSlot((Container)this.be.getUpgrades(), y, 152, 21 + y * 18, this.be);
            s.setListener(() -> this.be.checkUpgradeEquipped(index));
            this.addSlot(s);
            uSlots.add(s);
        }
        this.upgradeSlots = ImmutableList.copyOf(uSlots);
        ArrayList<EasySlot> iSlots = new ArrayList<EasySlot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                EasySlot s = new EasySlot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 161 + y * 18);
                iSlots.add(s);
                this.addSlot(s);
            }
        }
        for (int x = 0; x < 9; ++x) {
            EasySlot s = new EasySlot((Container)inventory, x, 8 + x * 18, 219);
            iSlots.add(s);
            this.addSlot(s);
        }
        this.inventorySlots = ImmutableList.copyOf(iSlots);
    }

    public void SetUpgradeSlotVisibility(boolean visible) {
        EasySlot.SetActive(this.upgradeSlots, visible);
    }

    public void SetCoinSlotVisibility(boolean visible) {
        EasySlot.SetActive(this.coinSlots, visible);
    }

    public void SetInventoryVisibility(boolean visible) {
        EasySlot.SetActive(this.inventorySlots, visible);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack clickedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            clickedStack = slotStack.copy();
            if (index < 30 ? !this.moveItemStackTo(slotStack, 30, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, 30, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return clickedStack;
    }

    public void removed(@Nonnull Player player) {
        super.removed(player);
        this.be.stopOpen(player);
    }

    public final void AddExtraHandler(@Nonnull Consumer<LazyPacketData> extraHandler) {
        this.extraHandler = extraHandler;
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        this.extraHandler.accept(message);
        if (message.contains("SetUpgradeActive") && message.contains("Slot")) {
            CoinChestUpgradeData data = this.be.getChestUpgradeForSlot(message.getInt("Slot"));
            data.setActive(message.getBoolean("SetUpgradeActive"));
        }
        for (CoinChestUpgradeData data : this.be.getChestUpgrades()) {
            data.upgrade.HandleMenuMessage(this, data, message);
        }
    }
}

