/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.SafeEjectionAPI;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.containers.SuppliedContainer;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EjectionRecoveryMenu
extends LazyMessageMenu {
    public static final MenuProvider PROVIDER = new Provider();
    private int selectedIndex = 0;
    private final Container dummyContainer = new SimpleContainer(54);

    public EjectionRecoveryMenu(int menuID, Inventory inventory) {
        this(ModMenus.EJECTION_RECOVERY.get(), menuID, inventory);
    }

    public List<EjectionData> getValidEjectionData() {
        return SafeEjectionAPI.getApi().getDataForPlayer(this.player);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public EjectionData getSelectedData() {
        List<EjectionData> data = this.getValidEjectionData();
        if (!data.isEmpty() && this.selectedIndex >= 0 && this.selectedIndex < data.size()) {
            return data.get(this.selectedIndex);
        }
        return null;
    }

    private Container getSelectedContainer() {
        List<EjectionData> data = this.getValidEjectionData();
        if (this.isServer() && !data.isEmpty() && (this.selectedIndex < 0 || this.selectedIndex >= data.size())) {
            this.changeSelection(this.selectedIndex);
        }
        if (!data.isEmpty() && this.selectedIndex >= 0 && this.selectedIndex < data.size()) {
            return data.get(this.selectedIndex).getContents();
        }
        return this.dummyContainer;
    }

    private void markSelectedDirty() {
        EjectionData data = this.getSelectedData();
        if (data != null) {
            data.setChanged();
        }
    }

    protected EjectionRecoveryMenu(MenuType<?> type, int menuID, Inventory inventory) {
        super(type, menuID, inventory);
        int x;
        int y;
        SuppliedContainer ejectionContainer = new SuppliedContainer(this::getSelectedContainer);
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 9; ++x) {
                OutputSlot slot = new OutputSlot(ejectionContainer, x + y * 9, 8 + x * 18, 18 + y * 18);
                slot.setListener(this::markSelectedDirty);
                this.addSlot(slot);
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 140 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.addSlot(new Slot((Container)inventory, x2, 8 + x2 * 18, 198));
        }
    }

    @Override
    public void HandleMessage(LazyPacketData message) {
        if (message.contains("ChangeSelection", (byte)2)) {
            this.changeSelection(message.getInt("ChangeSelection"));
        }
        if (message.contains("SelectionChanged")) {
            this.selectedIndex = message.getInt("SelectionChanged");
        }
        if (message.contains("SplitData")) {
            this.splitSelectedData();
        }
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotIndex < 54 ? !this.moveItemStackTo(itemstack1, 54, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 54, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, this.dummyContainer);
    }

    public void splitSelectedData() {
        if (this.isClient()) {
            this.SendMessage(this.builder().setFlag("SplitData"));
            return;
        }
        EjectionData data = this.getSelectedData();
        if (data != null && data.canSplit()) {
            LightmansCurrency.LogDebug("Splitting data from the server!");
            try {
                data.splitContents();
                data.setChanged();
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error splitting Ejection Contents!", t);
            }
        }
    }

    public void changeSelection(int newSelection) {
        this.changeSelection(newSelection, this.getValidEjectionData().size());
    }

    private void changeSelection(int newSelection, int dataSize) {
        if (this.isClient()) {
            this.SendMessage(this.builder().setInt("ChangeSelection", newSelection));
            return;
        }
        int oldSelection = this.selectedIndex;
        this.selectedIndex = MathUtil.clamp(newSelection, 0, dataSize - 1);
        if (this.selectedIndex != oldSelection && this.isServer()) {
            this.SendMessage(this.builder().setInt("SelectionChanged", this.selectedIndex));
        }
    }

    private static class Provider
    implements EasyMenuProvider {
        private Provider() {
        }

        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return new EjectionRecoveryMenu(id, inventory);
        }
    }
}

