/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.validation.types;

import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class BlockValidator
extends MenuValidator {
    public static final MenuValidatorType TYPE = new Type();
    private final BlockPos pos;
    private final Block block;

    protected BlockValidator(@Nonnull BlockPos pos, @Nonnull Block block) {
        super(TYPE);
        this.pos = pos;
        this.block = block;
    }

    public static MenuValidator of(@Nonnull BlockPos pos, @Nonnull Block block) {
        return new BlockValidator(pos, block);
    }

    @Override
    protected void encodeAdditional(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(BuiltInRegistries.BLOCK.getKey((Object)this.block).toString());
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        tag.put("Position", (Tag)TagUtil.saveBlockPos(this.pos));
        tag.putString("Block", BuiltInRegistries.BLOCK.getKey((Object)this.block).toString());
    }

    @Override
    public boolean stillValid(@Nonnull Player player) {
        return player.level().getBlockState(this.pos).is(this.block) && player.distanceToSqr((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    private static final class Type
    extends MenuValidatorType {
        private Type() {
            super(VersionUtil.lcResource("block"));
        }

        @Override
        @Nonnull
        public MenuValidator decode(@Nonnull FriendlyByteBuf buffer) {
            return BlockValidator.of(buffer.readBlockPos(), (Block)BuiltInRegistries.BLOCK.get(VersionUtil.parseResource(buffer.readUtf())));
        }

        @Override
        @Nonnull
        public MenuValidator load(@Nonnull CompoundTag tag) {
            return BlockValidator.of(TagUtil.loadBlockPos(tag.getCompound("Position")), (Block)BuiltInRegistries.BLOCK.get(VersionUtil.parseResource(tag.getString("Block"))));
        }
    }
}

