/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.validation.types;

import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemValidator
extends MenuValidator {
    public static MenuValidatorType TYPE = new Type();
    private final Item item;

    public ItemValidator(ItemLike item) {
        super(TYPE);
        this.item = item.asItem();
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)this.item));
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        tag.putString("Item", BuiltInRegistries.ITEM.getKey((Object)this.item).toString());
    }

    @Override
    public boolean stillValid(Player player) {
        int count = InventoryUtil.GetItemCount((Container)player.getInventory(), this.item);
        if (count > 0) {
            return true;
        }
        return LCCurios.isLoaded() && LCCurios.hasItem((LivingEntity)player, s -> s.is(this.item));
    }

    private static class Type
    extends MenuValidatorType {
        protected Type() {
            super(VersionUtil.lcResource("item"));
        }

        @Override
        public MenuValidator decode(FriendlyByteBuf buffer) {
            return new ItemValidator((ItemLike)BuiltInRegistries.ITEM.get(buffer.readResourceLocation()));
        }

        @Override
        public MenuValidator load(CompoundTag tag) {
            return new ItemValidator((ItemLike)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(tag.getString("Item"))));
        }
    }
}

