/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.variant;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IDeepBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockValidator;
import io.github.lightman314.lightmanscurrency.common.menus.variant.VariantSelectMenu;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockVariantSelectMenu
extends VariantSelectMenu {
    private final BlockPos pos;
    private final Level level;
    private final IVariantBlock variantBlock;
    private final Block block;
    private int pendingClose = -1;
    private final List<Pair<BlockPos, Boolean>> pendingUpdates = new ArrayList<Pair<BlockPos, Boolean>>();

    public Block getBlock() {
        return this.block;
    }

    public IVariantBlock getVariantBlock() {
        return this.variantBlock;
    }

    public BlockVariantSelectMenu(int id, Inventory inventory, BlockPos pos) {
        super(ModMenus.VARIANT_SELECT_BLOCK.get(), id, inventory);
        this.pos = pos;
        this.level = inventory.player.level();
        this.block = this.level.getBlockState(this.pos).getBlock();
        this.variantBlock = VariantProvider.getVariantBlock(this.block);
        if (this.variantBlock != null) {
            this.addValidator(BlockValidator.of(this.pos, this.block));
        } else {
            this.addValidator(() -> false);
        }
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected void changeVariant(@Nullable ResourceLocation variant) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        IVariantDataStorage data = IVariantDataStorage.get((BlockGetter)this.level, this.pos);
        if (data != null) {
            if (data.isVariantLocked() && !this.player.isCreative()) {
                LightmansCurrency.LogDebug(this.player.getName().getString() + " attempted to change the variant of a locked block!");
                return;
            }
            data.setVariant(variant);
            this.updateVariantState(this.level, this.pos, variant != null);
            this.pendingClose = 1;
        }
    }

    private void updateVariantState(Level level, BlockPos pos, boolean variant) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof IWideBlock) {
            IWideBlock wideBlock = (IWideBlock)block;
            this.updateWideStates(wideBlock, level, pos, variant);
        } else {
            block = state.getBlock();
            if (block instanceof IDeepBlock) {
                IDeepBlock deepBlock = (IDeepBlock)block;
                this.updateDeepStates(deepBlock, level, pos, variant);
            } else {
                block = state.getBlock();
                if (block instanceof ITallBlock) {
                    ITallBlock tallBlock = (ITallBlock)block;
                    this.updateTallStates(tallBlock, level, pos, variant);
                } else {
                    this.updateSingleState(level, pos, variant);
                }
            }
        }
    }

    private void updateWideStates(IWideBlock wideBlock, Level level, BlockPos pos, boolean variant) {
        if (wideBlock instanceof IDeepBlock) {
            IDeepBlock deepBlock = (IDeepBlock)((Object)wideBlock);
            this.updateDeepStates(deepBlock, level, pos, variant);
            this.updateDeepStates(deepBlock, level, wideBlock.getOtherSide(pos, level.getBlockState(pos)), variant);
        } else if (wideBlock instanceof ITallBlock) {
            ITallBlock tallBlock = (ITallBlock)((Object)wideBlock);
            this.updateTallStates(tallBlock, level, pos, variant);
            this.updateTallStates(tallBlock, level, wideBlock.getOtherSide(pos, level.getBlockState(pos)), variant);
        } else {
            this.updateSingleState(level, pos, variant);
            pos = wideBlock.getOtherSide(pos, level.getBlockState(pos));
            this.updateSingleState(level, pos, variant);
        }
    }

    private void updateDeepStates(IDeepBlock deepBlock, Level level, BlockPos pos, boolean variant) {
        if (deepBlock instanceof ITallBlock) {
            ITallBlock tallBlock = (ITallBlock)((Object)deepBlock);
            this.updateTallStates(tallBlock, level, pos, variant);
            this.updateTallStates(tallBlock, level, deepBlock.getOtherDepth(pos, level.getBlockState(pos)), variant);
        } else {
            this.updateSingleState(level, pos, variant);
            pos = deepBlock.getOtherDepth(pos, level.getBlockState(pos));
            this.updateSingleState(level, pos, variant);
        }
    }

    private void updateTallStates(ITallBlock tallBlock, Level level, BlockPos pos, boolean variant) {
        this.updateSingleState(level, pos, variant);
        pos = tallBlock.getOtherHeight(pos, level.getBlockState(pos));
        this.updateSingleState(level, pos, variant);
    }

    private void updateSingleState(Level level, BlockPos pos, boolean variant) {
        this.updateSingleState(level, pos, variant, true);
    }

    private void updateSingleState(Level level, BlockPos pos, boolean variant, boolean allowTick) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() != this.block) {
            return;
        }
        if (variant == (Boolean)state.getValue((Property)IVariantBlock.VARIANT) && allowTick) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(!variant)));
            this.pendingUpdates.add((Pair<BlockPos, Boolean>)Pair.of((Object)pos, (Object)variant));
            LightmansCurrency.LogDebug("Scheduled tick at " + String.valueOf(pos));
        } else {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(variant)));
        }
    }

    @Override
    @Nullable
    public ResourceLocation getSelectedVariant() {
        IVariantDataStorage data = IVariantDataStorage.get((BlockGetter)this.level, this.pos);
        if (data != null) {
            return data.getCurrentVariant();
        }
        return null;
    }

    private void sendUpdateModelMessage(BlockPos pos) {
        this.SendMessageToClient(this.builder().setBlockPos("UpdateModel", pos));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public void removed(Player player) {
        this.runPendingUpdates();
        NeoForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    private void serverTick(ServerTickEvent.Pre event) {
        if (this.pendingClose < 0) {
            return;
        }
        if (this.pendingClose-- < 1) {
            this.runPendingUpdates();
            this.player.closeContainer();
        }
    }

    private void runPendingUpdates() {
        for (Pair<BlockPos, Boolean> update : new ArrayList<Pair<BlockPos, Boolean>>(this.pendingUpdates)) {
            BlockState existingState = this.level.getBlockState((BlockPos)update.getFirst());
            LightmansCurrency.LogDebug("Executed tick at " + String.valueOf(update.getFirst()));
            this.updateSingleState(this.level, (BlockPos)update.getFirst(), (Boolean)update.getSecond(), false);
        }
        this.pendingUpdates.clear();
    }

    public static MenuProvider providerFor(BlockPos pos) {
        return new Provider(pos);
    }

    private record Provider(BlockPos pos) implements EasyMenuProvider
    {
        @Nullable
        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
            return new BlockVariantSelectMenu(containerId, playerInventory, this.pos);
        }
    }
}

