/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.variant;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.variant.ItemVariantSlot;
import io.github.lightman314.lightmanscurrency.common.menus.variant.VariantSelectMenu;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemVariantSelectMenu
extends VariantSelectMenu {
    private final ItemVariantSlot variantSlot = new ItemVariantSlot(155, 72);

    public ItemVariantSelectMenu(int id, Inventory inventory) {
        super(ModMenus.VARIANT_SELECT_ITEM.get(), id, inventory);
        this.addSlot(this.variantSlot);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 11 + x * 18, 154 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 11 + x * 18, 212));
        }
    }

    public ItemStack getVariantStack() {
        return this.variantSlot.getItem().copy();
    }

    private boolean validSlotItem() {
        return VariantProvider.getVariantItem(this.variantSlot.getItem().getItem()) != null;
    }

    @Override
    protected void changeVariant(@Nullable ResourceLocation newVariant) {
        ItemStack variantItem = this.variantSlot.getItem();
        if (variantItem.isEmpty()) {
            return;
        }
        if (variantItem.has(ModDataComponents.VARIANT_LOCK) && !this.player.isCreative()) {
            LightmansCurrency.LogDebug(this.player.getName().getString() + " attempted to change the variant of a locked item!");
            return;
        }
        if (newVariant == null) {
            variantItem.remove(ModDataComponents.MODEL_VARIANT);
        } else if (VariantProvider.getVariantItem(variantItem) != null) {
            variantItem.set(ModDataComponents.MODEL_VARIANT, (Object)newVariant);
        }
    }

    @Override
    @Nullable
    public ResourceLocation getSelectedVariant() {
        if (this.validSlotItem()) {
            ItemStack variantItem = this.variantSlot.getItem();
            return (ResourceLocation)variantItem.getOrDefault(ModDataComponents.MODEL_VARIANT, null);
        }
        return null;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack clickedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            clickedStack = slotStack.copy();
            if (index < 1 ? !this.moveItemStackTo(slotStack, 1, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return clickedStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, this.variantSlot.container);
    }

    public static MenuProvider providerFor() {
        return Provider.INSTANCE;
    }

    private static class Provider
    implements EasyMenuProvider {
        private static final Provider INSTANCE = new Provider();

        private Provider() {
        }

        @Nullable
        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
            return new ItemVariantSelectMenu(containerId, playerInventory);
        }
    }
}

