/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money.ancient_money.handlers;

import io.github.lightman314.lightmanscurrency.api.capability.money.MoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.items.AncientCoinItem;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.money.ancient_money.AncientMoneyValue;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class AncientContainerMoneyHandler
extends MoneyHandler {
    private final Container container;
    private final Consumer<ItemStack> overflowHandler;

    public AncientContainerMoneyHandler(@Nonnull Container container, @Nonnull Consumer<ItemStack> overflowHandler) {
        this.container = container;
        this.overflowHandler = overflowHandler;
    }

    @Override
    @Nonnull
    public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
        if (insertAmount instanceof AncientMoneyValue) {
            AncientMoneyValue value = (AncientMoneyValue)insertAmount;
            if (simulation) {
                return MoneyValue.empty();
            }
            List<ItemStack> coins = value.getAsSeperatedItemList();
            ArrayList<ItemStack> extra = new ArrayList<ItemStack>();
            for (ItemStack c : coins) {
                ItemStack e = InventoryUtil.TryPutItemStack(this.container, c);
                if (e.isEmpty()) continue;
                extra.add(e);
            }
            for (ItemStack e : extra) {
                this.overflowHandler.accept(e);
            }
            return MoneyValue.empty();
        }
        return insertAmount;
    }

    @Override
    @Nonnull
    public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
        if (extractAmount instanceof AncientMoneyValue) {
            AncientMoneyValue value = (AncientMoneyValue)extractAmount;
            if (this.getStoredMoney().containsValue(extractAmount)) {
                long leftToTake = value.count;
                if (leftToTake > Integer.MAX_VALUE) {
                    return extractAmount;
                }
                for (int i = 0; i < this.container.getContainerSize(); ++i) {
                    AncientCoinType type;
                    ItemStack item = this.container.getItem(i);
                    if (simulation) {
                        item = item.copy();
                    }
                    if ((type = AncientCoinItem.getAncientCoinType(item)) == null || type != value.type || leftToTake <= 0L) continue;
                    leftToTake -= (long)item.split((int)leftToTake).getCount();
                    if (simulation) continue;
                    if (item.isEmpty()) {
                        this.container.setItem(i, ItemStack.EMPTY);
                        continue;
                    }
                    this.container.setItem(i, item);
                }
                if (leftToTake <= 0L) {
                    return MoneyValue.empty();
                }
                return AncientMoneyValue.of(value.type, leftToTake);
            }
        }
        return extractAmount;
    }

    @Override
    public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
        return value instanceof AncientMoneyValue;
    }

    @Override
    protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
        AncientContainerMoneyHandler.queryContainerContents(this.container, builder);
    }

    public static void queryContainerContents(@Nonnull Container container, @Nonnull MoneyView.Builder builder) {
        HashMap<AncientCoinType, Integer> map = new HashMap<AncientCoinType, Integer>();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack item = container.getItem(i);
            AncientCoinType type2 = AncientCoinItem.getAncientCoinType(item);
            if (type2 == null) continue;
            map.put(type2, map.getOrDefault((Object)type2, 0) + item.getCount());
        }
        map.forEach((type, count) -> builder.add(AncientMoneyValue.of(type, count.intValue())));
    }
}

