/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.TeamOwner;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ChangeOwnerNotification
extends SingleLineNotification {
    public static final NotificationType<ChangeOwnerNotification> TYPE = new NotificationType<ChangeOwnerNotification>(VersionUtil.lcResource("change_ownership"), ChangeOwnerNotification::new);
    PlayerReference player;
    Owner newOwner;
    Owner oldOwner;

    private ChangeOwnerNotification() {
    }

    public ChangeOwnerNotification(PlayerReference player, Owner newOwner, Owner oldOwner) {
        this.player = player;
        this.newOwner = newOwner.copy();
        this.newOwner.setParent(this);
        this.oldOwner = oldOwner.copy();
        this.oldOwner.setParent(this);
    }

    protected NotificationType<ChangeOwnerNotification> getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    public MutableComponent getMessage() {
        if (this.newOwner.asPlayerReference().isExact(this.player)) {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_OWNER_TAKEN.get(this.newOwner.getName(), this.oldOwner.getName());
        }
        if (this.oldOwner.asPlayerReference().isExact(this.player)) {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_OWNER_PASSED.get(this.oldOwner.getName(), this.newOwner.getName());
        }
        return LCText.NOTIFICATION_SETTINGS_CHANGE_OWNER_TRANSFERRED.get(this.player.getName(true), this.oldOwner.getName(), this.newOwner.getName());
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.put("Player", (Tag)this.player.save());
        compound.put("NewOwner", (Tag)this.newOwner.save(lookup));
        compound.put("OldOwner", (Tag)this.oldOwner.save(lookup));
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        this.player = PlayerReference.load(compound.getCompound("Player"));
        this.newOwner = ChangeOwnerNotification.safeLoad(compound.getCompound("NewOwner"), lookup);
        this.newOwner.setParent(this);
        this.oldOwner = ChangeOwnerNotification.safeLoad(compound.getCompound("OldOwner"), lookup);
        this.oldOwner.setParent(this);
    }

    private static Owner safeLoad(CompoundTag tag, HolderLookup.Provider lookup) {
        PlayerReference pr;
        if (tag.contains("Type")) {
            Owner o = Owner.load(tag, lookup);
            return o != null ? o : Owner.getNull();
        }
        if (tag.contains("Player") && (pr = PlayerReference.load(tag.getCompound("Player"))) != null) {
            return PlayerOwner.of(pr);
        }
        if (tag.contains("Team")) {
            long teamID = tag.getLong("Team");
            return TeamOwner.of(teamID);
        }
        return Owner.getNull();
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof ChangeOwnerNotification) {
            ChangeOwnerNotification n = (ChangeOwnerNotification)other;
            return n.player.is(this.player) && n.newOwner.matches(this.newOwner) && n.oldOwner.matches(this.oldOwner);
        }
        return false;
    }
}

