/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.player;

import io.github.lightman314.lightmanscurrency.network.message.command.SPacketSyncAdminList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class LCAdminMode {
    private static final List<UUID> adminPlayers = new ArrayList<UUID>();

    public static boolean isAdminPlayer(@Nullable Player player) {
        return player != null && adminPlayers.contains(player.getUUID()) && player.hasPermissions(2);
    }

    public static void ToggleAdminPlayer(ServerPlayer player) {
        UUID playerID = player.getUUID();
        if (adminPlayers.contains(playerID)) {
            adminPlayers.remove(playerID);
        } else {
            adminPlayers.add(playerID);
        }
        LCAdminMode.sendSyncPacketToAll();
    }

    public static void sendSyncPacket(Player target) {
        new SPacketSyncAdminList(adminPlayers).sendTo(target);
    }

    public static void sendSyncPacketToAll() {
        new SPacketSyncAdminList(adminPlayers).sendToAll();
    }

    public static void loadAdminPlayers(List<UUID> serverAdminList) {
        adminPlayers.clear();
        adminPlayers.addAll(serverAdminList);
    }
}

