/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public final class PersistentAuctionData {
    public final String id;
    public final long duration;
    private final List<ItemStack> items;
    private final MoneyValue startBid;
    private final MoneyValue minBid;
    private final boolean overtime;

    @Nonnull
    public List<ItemStack> getAuctionItems() {
        return InventoryUtil.copyList(this.items);
    }

    public MoneyValue getStartingBid() {
        return this.startBid;
    }

    public MoneyValue getMinimumBidDifference() {
        return this.minBid;
    }

    public boolean overtimeAllowed() {
        return this.overtime;
    }

    private PersistentAuctionData(String id, long duration, List<ItemStack> items, MoneyValue startBid, MoneyValue minBid, boolean overtime) {
        this.id = id;
        this.duration = duration;
        this.items = items;
        this.startBid = startBid;
        this.minBid = minBid;
        this.overtime = overtime;
    }

    public AuctionTradeData createAuction() {
        return new AuctionTradeData(this);
    }

    @Nonnull
    public static PersistentAuctionData load(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        String id = json.has("id") ? GsonHelper.getAsString((JsonObject)json, (String)"id") : GsonHelper.getAsString((JsonObject)json, (String)"ID");
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (json.has("Item1")) {
            items.add(FileUtil.parseItemStack(GsonHelper.getAsJsonObject((JsonObject)json, (String)"Item1"), lookup));
        }
        if (json.has("Item2")) {
            items.add(FileUtil.parseItemStack(GsonHelper.getAsJsonObject((JsonObject)json, (String)"Item2"), lookup));
        }
        if (items.isEmpty()) {
            throw new JsonSyntaxException("Auction has no 'Item1' or 'Item2' entry!");
        }
        long duration = Math.max(GsonHelper.getAsLong((JsonObject)json, (String)"Duration", (long)AuctionTradeData.GetDefaultDuration()), AuctionTradeData.GetMinimumDuration());
        MoneyValue startingBid = MoneyValue.loadFromJson(GsonHelper.getNonNull((JsonObject)json, (String)"StartingBid"));
        if (startingBid.isEmpty() || startingBid.isFree()) {
            throw new JsonSyntaxException("StartingBid cannot be empty and/or free!");
        }
        MoneyValue minimumBid = startingBid.getSmallestValue();
        if (json.has("MinimumBid")) {
            minimumBid = MoneyValue.loadFromJson(GsonHelper.getNonNull((JsonObject)json, (String)"MinimumBid"));
        }
        if (!startingBid.getUniqueName().equals(minimumBid.getUniqueName())) {
            throw new JsonSyntaxException("StartingBid and MinimumBid are not compatible money values!");
        }
        boolean overtime = GsonHelper.getAsBoolean((JsonObject)json, (String)"Overtime", (boolean)false);
        return new PersistentAuctionData(id, duration, items, startingBid, minimumBid, overtime);
    }
}

