/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen;

import io.github.lightman314.lightmanscurrency.datagen.client.LCBlockStateProvider;
import io.github.lightman314.lightmanscurrency.datagen.client.LCItemPositionProvider;
import io.github.lightman314.lightmanscurrency.datagen.client.LCModelVariantProvider;
import io.github.lightman314.lightmanscurrency.datagen.client.language.EnglishProvider;
import io.github.lightman314.lightmanscurrency.datagen.client.resourcepacks.LCCloserItemPositionProvider;
import io.github.lightman314.lightmanscurrency.datagen.common.LCDatapackProvider;
import io.github.lightman314.lightmanscurrency.datagen.common.advancements.LCAdvancementProvider;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.LCRecipeProvider;
import io.github.lightman314.lightmanscurrency.datagen.common.loot.LCLootModifierProvider;
import io.github.lightman314.lightmanscurrency.datagen.common.loot.LCLootTableProvider;
import io.github.lightman314.lightmanscurrency.datagen.common.tags.LCBlockTagProvider;
import io.github.lightman314.lightmanscurrency.datagen.common.tags.LCEnchantmentTagProvider;
import io.github.lightman314.lightmanscurrency.datagen.common.tags.LCItemTagProvider;
import io.github.lightman314.lightmanscurrency.datagen.common.tags.LCPoiTagProvider;
import io.github.lightman314.lightmanscurrency.datagen.integration.LCComputerCraftProvider;
import io.github.lightman314.lightmanscurrency.datagen.integration.LCCuriosProvider;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="lightmanscurrency")
public class LCDataEventListener {
    @SubscribeEvent
    public static void onDataGen(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupHolder = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (ModList.get().isLoaded("computercraft")) {
            LCDatapackProvider.registerAddon(LCComputerCraftProvider::datapackAddon);
        }
        generator.addProvider(event.includeServer(), (DataProvider)new LCRecipeProvider(output, lookupHolder));
        generator.addProvider(event.includeServer(), (DataProvider)LCLootTableProvider.create(output, lookupHolder));
        generator.addProvider(event.includeServer(), (DataProvider)new LCLootModifierProvider(output, lookupHolder));
        generator.addProvider(event.includeServer(), (DataProvider)new LCAdvancementProvider(output, lookupHolder, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LCDatapackProvider(output, lookupHolder));
        LCBlockTagProvider blockTagProvider = new LCBlockTagProvider(output, lookupHolder, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new LCItemTagProvider(output, lookupHolder, blockTagProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LCPoiTagProvider(output, lookupHolder, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new LCEnchantmentTagProvider(output, lookupHolder, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new LCBlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new LCItemPositionProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new LCCloserItemPositionProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new LCModelVariantProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new EnglishProvider(output));
        if (LCCurios.isLoaded()) {
            generator.addProvider(event.includeServer(), (DataProvider)new LCCuriosProvider(output, existingFileHelper, lookupHolder));
        }
    }
}

