/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.loot.packs;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.common.loot.ConfigItemTier;
import io.github.lightman314.lightmanscurrency.common.loot.LCLootTables;
import io.github.lightman314.lightmanscurrency.common.loot.entries.ConfigLoot;
import io.github.lightman314.lightmanscurrency.datagen.common.loot.SimpleSubProvider;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ChestAddonLoot
extends SimpleSubProvider {
    public ChestAddonLoot(HolderLookup.Provider lookup) {
        super(lookup);
    }

    @Override
    public void generate() {
        ChestLootEntryData T1 = new ChestLootEntryData(ConfigItemTier.T1, 1.0f, 10.0f, 1);
        ChestLootEntryData T2 = new ChestLootEntryData(ConfigItemTier.T2, 1.0f, 10.0f, 2);
        ChestLootEntryData T3 = new ChestLootEntryData(ConfigItemTier.T3, 1.0f, 10.0f, 3);
        ChestLootEntryData T4 = new ChestLootEntryData(ConfigItemTier.T4, 1.0f, 10.0f, 4);
        ChestLootEntryData T5 = new ChestLootEntryData(ConfigItemTier.T5, 1.0f, 8.0f, 5);
        ChestLootEntryData T6 = new ChestLootEntryData(ConfigItemTier.T6, 1.0f, 3.0f, 6);
        this.register(LCLootTables.CHEST_DROPS_T1, LootTable.lootTable().withPool(ChestAddonLoot.GenerateChestCoinPool((List<ChestLootEntryData>)ImmutableList.of((Object)T1), 1.0f, 5.0f)));
        this.register(LCLootTables.CHEST_DROPS_T2, LootTable.lootTable().withPool(ChestAddonLoot.GenerateChestCoinPool((List<ChestLootEntryData>)ImmutableList.of((Object)T1, (Object)T2), 1.0f, 5.0f)));
        this.register(LCLootTables.CHEST_DROPS_T3, LootTable.lootTable().withPool(ChestAddonLoot.GenerateChestCoinPool((List<ChestLootEntryData>)ImmutableList.of((Object)T1, (Object)T2, (Object)T3), 2.0f, 6.0f)));
        this.register(LCLootTables.CHEST_DROPS_T4, LootTable.lootTable().withPool(ChestAddonLoot.GenerateChestCoinPool((List<ChestLootEntryData>)ImmutableList.of((Object)T1, (Object)T2, (Object)T3, (Object)T4), 3.0f, 6.0f)));
        this.register(LCLootTables.CHEST_DROPS_T5, LootTable.lootTable().withPool(ChestAddonLoot.GenerateChestCoinPool((List<ChestLootEntryData>)ImmutableList.of((Object)T1, (Object)T2, (Object)T3, (Object)T4, (Object)T5), 3.0f, 6.0f)));
        this.register(LCLootTables.CHEST_DROPS_T6, LootTable.lootTable().withPool(ChestAddonLoot.GenerateChestCoinPool((List<ChestLootEntryData>)ImmutableList.of((Object)T1, (Object)T2, (Object)T3, (Object)T4, (Object)T5, (Object)T6), 3.0f, 6.0f)));
    }

    private static LootPool.Builder GenerateChestCoinPool(List<ChestLootEntryData> lootEntries, float minRolls, float maxRolls) {
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)minRolls, (float)maxRolls));
        for (ChestLootEntryData entry : lootEntries) {
            builder.add((LootPoolEntryContainer.Builder)ConfigLoot.lootTableTier(entry.tier).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)entry.minCount, (float)entry.maxCount))).setWeight(entry.weight));
        }
        return builder;
    }

    private record ChestLootEntryData(ConfigItemTier tier, float minCount, float maxCount, int weight) {
    }
}

