/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.loot.packs;

import io.github.lightman314.lightmanscurrency.common.loot.ConfigItemTier;
import io.github.lightman314.lightmanscurrency.common.loot.LCLootTables;
import io.github.lightman314.lightmanscurrency.common.loot.entries.ConfigLoot;
import io.github.lightman314.lightmanscurrency.datagen.common.loot.SimpleSubProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class EntityAddonLoot
extends SimpleSubProvider {
    public EntityAddonLoot(HolderLookup.Provider lookup) {
        super(lookup);
    }

    @Override
    public void generate() {
        LootPool.Builder t1 = this.GenerateEntityCoinPool(ConfigItemTier.T1, 1.0f, 10.0f, 0.75f, "T1");
        LootPool.Builder t2 = this.GenerateEntityCoinPool(ConfigItemTier.T2, 1.0f, 5.0f, 0.5f, "T2");
        LootPool.Builder t3 = this.GenerateEntityCoinPool(ConfigItemTier.T3, 1.0f, 5.0f, 0.25f, "T3");
        LootPool.Builder t4 = this.GenerateEntityCoinPool(ConfigItemTier.T4, 1.0f, 3.0f, 0.1f, "T4");
        LootPool.Builder t5 = this.GenerateEntityCoinPool(ConfigItemTier.T5, 1.0f, 3.0f, 0.05f, "T5");
        LootPool.Builder t6 = this.GenerateEntityCoinPool(ConfigItemTier.T6, 1.0f, 3.0f, 0.025f, "T6");
        this.register(LCLootTables.ENTITY_DROPS_T1, LootTable.lootTable().setParamSet(LootContextParamSets.ENTITY).withPool(t1));
        this.register(LCLootTables.ENTITY_DROPS_T2, LootTable.lootTable().withPool(t1).withPool(t2));
        this.register(LCLootTables.ENTITY_DROPS_T3, LootTable.lootTable().withPool(t1).withPool(t2).withPool(t3));
        this.register(LCLootTables.ENTITY_DROPS_T4, LootTable.lootTable().withPool(t1).withPool(t2).withPool(t3).withPool(t4));
        this.register(LCLootTables.ENTITY_DROPS_T5, LootTable.lootTable().withPool(t1).withPool(t2).withPool(t3).withPool(t4).withPool(t5));
        this.register(LCLootTables.ENTITY_DROPS_T6, LootTable.lootTable().withPool(t1).withPool(t2).withPool(t3).withPool(t4).withPool(t5).withPool(t6));
        t1 = this.BossPool(ConfigItemTier.T1);
        t2 = this.BossPool(ConfigItemTier.T2);
        t3 = this.BossPool(ConfigItemTier.T3);
        t4 = this.BossPool(ConfigItemTier.T4);
        t5 = this.BossPool(ConfigItemTier.T5);
        t6 = this.GenerateEntityCoinPool(ConfigItemTier.T6, 1.0f, 5.0f, 1.0f, "BossT6");
        this.register(LCLootTables.BOSS_DROPS_T1, LootTable.lootTable().withPool(t1));
        this.register(LCLootTables.BOSS_DROPS_T2, LootTable.lootTable().withPool(t1).withPool(t2));
        this.register(LCLootTables.BOSS_DROPS_T3, LootTable.lootTable().withPool(t1).withPool(t2).withPool(t3));
        this.register(LCLootTables.BOSS_DROPS_T4, LootTable.lootTable().withPool(t1).withPool(t2).withPool(t3).withPool(t4));
        this.register(LCLootTables.BOSS_DROPS_T5, LootTable.lootTable().withPool(t1).withPool(t2).withPool(t3).withPool(t4).withPool(t5));
        this.register(LCLootTables.BOSS_DROPS_T6, LootTable.lootTable().withPool(t1).withPool(t2).withPool(t3).withPool(t4).withPool(t5).withPool(t6));
    }

    private LootPool.Builder BossPool(ConfigItemTier tier) {
        return this.GenerateEntityCoinPool(tier, 10.0f, 30.0f, 1.0f, "Boss" + tier.name());
    }

    private LootPool.Builder GenerateEntityCoinPool(ConfigItemTier tier, float min, float max, float chance, String name) {
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ConfigLoot.lootTableTier(tier).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.lookup, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))));
        if (chance < 1.0f) {
            builder.when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.lookup, (float)chance, (float)0.01f));
        }
        return builder;
    }
}

