/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.util;

import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class CustomPathProvider {
    private final Path root;
    private final String kind;

    public CustomPathProvider(@Nonnull PackOutput output, @Nonnull PackOutput.Target target, @Nonnull String kind) {
        this(output, target, kind, null);
    }

    public CustomPathProvider(@Nonnull PackOutput output, @Nonnull PackOutput.Target target, @Nonnull String kind, @Nullable String subPack) {
        this.root = subPack != null ? output.getOutputFolder().resolve(subPack).resolve(CustomPathProvider.getDirectory(target)) : output.getOutputFolder(target);
        this.kind = kind;
    }

    public Path file(@Nonnull ResourceLocation location, @Nonnull String extension) {
        return this.root.resolve(location.getNamespace()).resolve(this.kind).resolve(location.getPath() + "." + extension);
    }

    public Path json(@Nonnull ResourceLocation location) {
        return this.file(location, "json");
    }

    private static String getDirectory(@Nonnull PackOutput.Target target) {
        return switch (target) {
            default -> throw new MatchException(null, null);
            case PackOutput.Target.RESOURCE_PACK -> "assets";
            case PackOutput.Target.DATA_PACK -> "data";
            case PackOutput.Target.REPORTS -> "reports";
        };
    }
}

