/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.reiplugin.ticket_station;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.crafting.MasterTicketRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.durability.DurabilityData;
import io.github.lightman314.lightmanscurrency.integration.reiplugin.ticket_station.TicketStationCategory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.common.Tags;

public class TicketStationDisplay
implements Display {
    protected List<EntryIngredient> inputs;
    protected List<EntryIngredient> outputs;
    protected Optional<ResourceLocation> location;
    public final boolean codeInputs;
    public final DurabilityData durabilityData;

    public TicketStationDisplay(RecipeHolder<TicketStationRecipe> holder) {
        this.inputs = Lists.newArrayList((Object[])new EntryIngredient[]{TicketStationDisplay.getModifierInput((TicketStationRecipe)holder.value()), EntryIngredients.ofIngredient((Ingredient)((TicketStationRecipe)holder.value()).getIngredient())});
        this.outputs = Collections.singletonList(EntryIngredients.of((ItemStack)((TicketStationRecipe)holder.value()).exampleResult()));
        this.location = Optional.of(holder.id());
        this.codeInputs = ((TicketStationRecipe)holder.value()).requiredCodeInput();
        this.durabilityData = ((TicketStationRecipe)holder.value()).getDurabilityData();
    }

    private static EntryIngredient getModifierInput(@Nonnull TicketStationRecipe recipe) {
        if (recipe instanceof MasterTicketRecipe) {
            MasterTicketRecipe mtr = (MasterTicketRecipe)recipe;
            return EntryIngredients.ofIngredient((Ingredient)Ingredient.of((TagKey)Tags.Items.DYES));
        }
        if (recipe instanceof TicketRecipe) {
            TicketRecipe tr = (TicketRecipe)recipe;
            return EntryIngredients.ofIngredient((Ingredient)tr.getMasterIngredient());
        }
        return EntryIngredients.ofItemStacks(recipe.jeiModifierList());
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return TicketStationCategory.ID;
    }
}

