/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.menu.IBankAccountMenu;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketBankInteraction
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketBankInteraction> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_bank_interaction"));
    public static final CustomPacket.Handler<CPacketBankInteraction> HANDLER = new H();
    boolean isDeposit;
    MoneyValue amount;

    public CPacketBankInteraction(boolean isDeposit, MoneyValue amount) {
        super(TYPE);
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketBankInteraction message) {
        buffer.writeBoolean(message.isDeposit);
        message.amount.encode(buffer);
    }

    private static CPacketBankInteraction decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketBankInteraction(buffer.readBoolean(), MoneyValue.decode(buffer));
    }

    private static final class H
    extends CustomPacket.Handler<CPacketBankInteraction> {
        private H() {
            super(TYPE, CustomPacket.easyCodec(CPacketBankInteraction::encode, CPacketBankInteraction::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketBankInteraction message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof IBankAccountMenu) {
                IBankAccountMenu menu = (IBankAccountMenu)abstractContainerMenu;
                if (message.isDeposit) {
                    BankAPI.getApi().BankDeposit(menu, message.amount);
                } else {
                    BankAPI.getApi().BankWithdraw(menu, message.amount);
                }
                menu.onDepositOrWithdraw();
            }
        }
    }
}

