/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketCreatePersistentAuction
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketCreatePersistentAuction> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_persistent_create_auction"));
    public static final CustomPacket.Handler<CPacketCreatePersistentAuction> HANDLER = new H();
    private static final String GENERATE_ID_FORMAT = "auction_";
    final CompoundTag auctionData;
    final String id;

    public CPacketCreatePersistentAuction(CompoundTag auctionData, String id) {
        super(TYPE);
        this.auctionData = auctionData;
        this.id = id;
    }

    @Nonnull
    private JsonObject getAuctionJson(@Nonnull String id, @Nonnull HolderLookup.Provider lookup) {
        AuctionTradeData auction = new AuctionTradeData(this.auctionData, lookup);
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        json = auction.saveToJson(json, lookup);
        return json;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketCreatePersistentAuction message) {
        buffer.writeNbt((Tag)message.auctionData);
        buffer.writeUtf(message.id);
    }

    private static CPacketCreatePersistentAuction decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketCreatePersistentAuction(CPacketCreatePersistentAuction.readNBT(buffer), buffer.readUtf());
    }

    private static class H
    extends CustomPacket.Handler<CPacketCreatePersistentAuction> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketCreatePersistentAuction::encode, CPacketCreatePersistentAuction::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketCreatePersistentAuction message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            if (LCAdminMode.isAdminPlayer(player)) {
                TraderDataCache data = TraderDataCache.TYPE.get(false);
                if (data == null) {
                    return;
                }
                RegistryAccess lookup = player.registryAccess();
                boolean generateID = message.id.isBlank();
                if (!generateID) {
                    JsonObject auctionJson = message.getAuctionJson(message.id, (HolderLookup.Provider)lookup);
                    JsonArray persistentAuctions = data.getPersistentTraderJson("Auctions");
                    for (int i = 0; i < persistentAuctions.size(); ++i) {
                        JsonObject auctionData = persistentAuctions.get(i).getAsJsonObject();
                        if (!auctionData.has("id") || !auctionData.get("id").getAsString().equals(message.id)) continue;
                        persistentAuctions.set(i, (JsonElement)auctionJson);
                        data.setPersistentTraderSection("Auctions", persistentAuctions, (HolderLookup.Provider)lookup);
                        player.sendSystemMessage((Component)LCText.MESSAGE_PERSISTENT_AUCTION_OVERWRITE.get(message.id));
                        return;
                    }
                    persistentAuctions.add((JsonElement)auctionJson);
                    data.setPersistentTraderSection("Auctions", persistentAuctions, (HolderLookup.Provider)lookup);
                    player.sendSystemMessage((Component)LCText.MESSAGE_PERSISTENT_AUCTION_ADD.get(message.id));
                } else {
                    int i;
                    ArrayList<String> knownIDs = new ArrayList<String>();
                    JsonArray persistentAuctions = data.getPersistentTraderJson("Auctions");
                    for (i = 0; i < persistentAuctions.size(); ++i) {
                        JsonObject auctionData = persistentAuctions.get(i).getAsJsonObject();
                        if (!auctionData.has("id")) continue;
                        knownIDs.add(auctionData.get("id").getAsString());
                    }
                    for (i = 1; i < Integer.MAX_VALUE; ++i) {
                        String genID = CPacketCreatePersistentAuction.GENERATE_ID_FORMAT + i;
                        if (!knownIDs.stream().noneMatch(id -> id.equals(genID))) continue;
                        persistentAuctions.add((JsonElement)message.getAuctionJson(genID, (HolderLookup.Provider)lookup));
                        data.setPersistentTraderSection("Auctions", persistentAuctions, (HolderLookup.Provider)lookup);
                        player.sendSystemMessage((Component)LCText.MESSAGE_PERSISTENT_AUCTION_ADD.get(genID));
                        return;
                    }
                    LightmansCurrency.LogError("Could not generate ID, as all auction_# ID's are somehow spoken for.");
                }
            } else {
                player.sendSystemMessage((Component)LCText.MESSAGE_PERSISTENT_AUCTION_FAIL.get(new Object[0]));
            }
        }
    }
}

