/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.playertrading;

import io.github.lightman314.lightmanscurrency.common.playertrading.PlayerTrade;
import io.github.lightman314.lightmanscurrency.common.playertrading.PlayerTradeManager;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketPlayerTradeInteraction
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketPlayerTradeInteraction> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_player_trade_interaction"));
    public static final CustomPacket.Handler<CPacketPlayerTradeInteraction> HANDLER = new H();
    private final int tradeID;
    private final CompoundTag message;

    public CPacketPlayerTradeInteraction(int tradeID, CompoundTag message) {
        super(TYPE);
        this.tradeID = tradeID;
        this.message = message;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketPlayerTradeInteraction message) {
        buffer.writeInt(message.tradeID);
        buffer.writeNbt((Tag)message.message);
    }

    private static CPacketPlayerTradeInteraction decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketPlayerTradeInteraction(buffer.readInt(), CPacketPlayerTradeInteraction.readNBT(buffer));
    }

    private static class H
    extends CustomPacket.Handler<CPacketPlayerTradeInteraction> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketPlayerTradeInteraction::encode, CPacketPlayerTradeInteraction::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketPlayerTradeInteraction message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            PlayerTrade trade = PlayerTradeManager.GetTrade(message.tradeID);
            if (trade != null) {
                trade.handleInteraction(player, message.message);
            }
        }
    }
}

