/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.time;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketSyncTime
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketSyncTime> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_sync_time"));
    public static final CustomPacket.Handler<SPacketSyncTime> HANDLER = new H();
    private final long time;

    public static void syncWith(@Nonnull Player player) {
        new SPacketSyncTime(TimeUtil.getCurrentTime()).sendTo(player);
    }

    private SPacketSyncTime(long time) {
        super(TYPE);
        this.time = time;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull SPacketSyncTime message) {
        buffer.writeLong(TimeUtil.getCurrentTime());
    }

    private static SPacketSyncTime decode(@Nonnull FriendlyByteBuf buffer) {
        return new SPacketSyncTime(buffer.readLong());
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncTime> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(SPacketSyncTime::encode, SPacketSyncTime::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketSyncTime message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            LightmansCurrency.getProxy().setTimeDesync(message.time);
        }
    }
}

