/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.BooleanOption;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxCollector;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketTaxInfo
extends ServerToClientPacket {
    public static final CustomPacketPayload.Type<SPacketTaxInfo> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_trader_tax_warning"));
    public static final CustomPacket.Handler<SPacketTaxInfo> HANDLER = new H();
    private final boolean serverTax;
    private final boolean playerTax;

    public SPacketTaxInfo(boolean server, boolean player) {
        super(TYPE);
        this.serverTax = server;
        this.playerTax = player;
    }

    public static void sendPacket(List<ITaxCollector> taxCollectors, Player player) {
        boolean serverTax = false;
        boolean playerTax = false;
        for (ITaxCollector tc : taxCollectors) {
            if (playerTax && serverTax) break;
            if (tc.isServerEntry()) {
                serverTax = true;
                continue;
            }
            playerTax = true;
        }
        new SPacketTaxInfo(serverTax, playerTax).sendTo(player);
    }

    private static void encode(FriendlyByteBuf buffer, SPacketTaxInfo message) {
        buffer.writeBoolean(message.serverTax);
        buffer.writeBoolean(message.playerTax);
    }

    private static SPacketTaxInfo decode(FriendlyByteBuf buffer) {
        return new SPacketTaxInfo(buffer.readBoolean(), buffer.readBoolean());
    }

    private static UnaryOperator<Style> disableEffect(BooleanOption configOption) {
        ConfigFile file = configOption.getFile();
        if (file == null) {
            return UnaryOperator.identity();
        }
        return style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)LCText.MESSAGE_TAX_COLLECTOR_PLACEMENT_DISABLE.get(new Object[0]))).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/lcconfig edit " + String.valueOf(configOption.getFile().getFileID()) + " " + configOption.getFullName() + " false"));
    }

    private static class H
    extends CustomPacket.Handler<SPacketTaxInfo> {
        private H() {
            super(TYPE, StreamCodec.of(SPacketTaxInfo::encode, SPacketTaxInfo::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketTaxInfo message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            TextEntry firstMessage;
            BooleanOption config;
            if (!(!message.serverTax || message.playerTax && ((Boolean)LCConfig.CLIENT.playerTaxWarning.get()).booleanValue())) {
                config = LCConfig.CLIENT.serverTaxWarning;
                firstMessage = LCText.MESSAGE_TAX_COLLECTOR_PLACEMENT_TRADER_SERVER_ONLY;
            } else {
                config = LCConfig.CLIENT.playerTaxWarning;
                firstMessage = LCText.MESSAGE_TAX_COLLECTOR_PLACEMENT_TRADER;
            }
            if (!((Boolean)config.get()).booleanValue()) {
                return;
            }
            LightmansCurrency.getProxy().sendClientMessage((Component)firstMessage.get(new Object[0]).withStyle(SPacketTaxInfo.disableEffect(config)));
            LightmansCurrency.getProxy().sendClientMessage((Component)LCText.MESSAGE_TAX_COLLECTOR_PLACEMENT_TRADER_INFO.get(new Object[0]).withStyle(SPacketTaxInfo.disableEffect(config)));
        }
    }
}

