/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.proxy;

import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.ConfigSelectionScreen;
import io.github.lightman314.lightmanscurrency.api.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.api.events.client.RegisterVariantPropertiesEvent;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.client.gui.screen.config.MasterCoinListConfigOption;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.renderer.LCItemRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.AuctionStandBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.BookTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.CoinChestRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.FreezerTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.GachaMachineBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.SlotMachineBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.BookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.EnchantedBookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.NormalBookRenderer;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandler;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.common.attachments.EventUnlocks;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModAttachmentTypes;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.data.types.NotificationDataCache;
import io.github.lightman314.lightmanscurrency.common.items.AncientCoinItem;
import io.github.lightman314.lightmanscurrency.common.items.MoneyBagItem;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.menus.PlayerTradeMenu;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.playertrading.ClientPlayerTrade;
import io.github.lightman314.lightmanscurrency.integration.IntegrationUtil;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.integration.curios.client.LCCuriosClient;
import io.github.lightman314.lightmanscurrency.integration.patchouli.LCPatchouli;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClientProxy
extends CommonProxy {
    private long timeOffset = 0L;
    private final Supplier<CoinChestBlockEntity> coinChestBE = Suppliers.memoize(() -> new CoinChestBlockEntity(BlockPos.ZERO, ModBlocks.COIN_CHEST.get().defaultBlockState()));

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void init(IEventBus eventBus, ModContainer modContainer) {
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)ConfigSelectionScreen.mixedFactory(LCConfig.CLIENT, LCConfig.COMMON, LCConfig.SERVER, MasterCoinListConfigOption.INSTANCE));
        eventBus.addListener(this::registerVariantProperties);
    }

    @Override
    public void setupClient() {
        ConfigFile.loadClientFiles(ConfigFile.LoadPhase.SETUP);
        BlockEntityRenderers.register(ModBlockEntities.ITEM_TRADER.get(), ItemTraderBlockEntityRenderer::create);
        BlockEntityRenderers.register(ModBlockEntities.FREEZER_TRADER.get(), FreezerTraderBlockEntityRenderer::create);
        BlockEntityRenderers.register(ModBlockEntities.SLOT_MACHINE_TRADER.get(), SlotMachineBlockEntityRenderer::create);
        BlockEntityRenderers.register(ModBlockEntities.BOOK_TRADER.get(), BookTraderBlockEntityRenderer::create);
        BlockEntityRenderers.register(ModBlockEntities.AUCTION_STAND.get(), AuctionStandBlockEntityRenderer::create);
        BlockEntityRenderers.register(ModBlockEntities.COIN_CHEST.get(), CoinChestRenderer::new);
        BlockEntityRenderers.register(ModBlockEntities.GACHA_MACHINE.get(), GachaMachineBlockEntityRenderer::create);
        ItemEditWidget.BlacklistCreativeTabs(CreativeModeTabs.HOTBAR, CreativeModeTabs.INVENTORY, CreativeModeTabs.SEARCH, CreativeModeTabs.OP_BLOCKS);
        ItemEditWidget.BlacklistItem(s -> s.getItem() instanceof TicketItem);
        ItemEditWidget.AddExtraItemAfter(new ItemStack((ItemLike)Items.WRITTEN_BOOK), Items.WRITABLE_BOOK);
        BookRenderer.register(NormalBookRenderer.GENERATOR);
        BookRenderer.register(EnchantedBookRenderer.GENERATOR);
        LCItemRenderer.registerBlockEntitySource(this::checkForCoinChest);
        ItemProperties.register((Item)ModItems.COIN_ANCIENT.get(), (ResourceLocation)AncientCoinItem.PROPERTY, (stack, level, player, seed) -> {
            AncientCoinType type = AncientCoinItem.getAncientCoinType(stack);
            return type == null ? 0.0f : (float)type.ordinal() + 1.0f;
        });
        ItemProperties.register((Item)ModBlocks.MONEY_BAG.get().asItem(), (ResourceLocation)MoneyBagItem.PROPERTY, (stack, level, player, seed) -> MoneyBagItem.getSize(stack));
        if (LCCurios.isLoaded()) {
            LCCuriosClient.registerRenderLayers();
        }
        IntegrationUtil.SafeRunIfLoaded("patchouli", LCPatchouli::init, "Error setting up Patchouli Compat!");
        RotationHandler.setup();
    }

    private void registerVariantProperties(RegisterVariantPropertiesEvent event) {
        event.register(VersionUtil.lcResource("item_position_data"), VariantProperties.ITEM_POSITION_DATA);
        event.register(VersionUtil.lcResource("freezer_door"), VariantProperties.FREEZER_DOOR_DATA);
        event.register(VersionUtil.lcResource("input_display_offset"), VariantProperties.INPUT_DISPLAY_OFFSET);
        event.register(VersionUtil.lcResource("tooltip_info"), VariantProperties.TOOLTIP_INFO);
        event.register(VersionUtil.lcResource("show_in_creative"), VariantProperties.SHOW_IN_CREATIVE);
        event.register(VersionUtil.lcResource("hidden"), VariantProperties.HIDDEN);
    }

    private BlockEntity checkForCoinChest(Block block) {
        if (block == ModBlocks.COIN_CHEST.get()) {
            return this.coinChestBE.get();
        }
        return null;
    }

    @Override
    public void receiveNotification(Notification notification) {
        Minecraft mc = Minecraft.getInstance();
        assert (mc.player != null);
        if (((NotificationEvent.NotificationReceivedOnClient)NeoForge.EVENT_BUS.post((Event)new NotificationEvent.NotificationReceivedOnClient(mc.player.getUUID(), NotificationDataCache.TYPE.get(true).getNotifications((Player)mc.player), notification))).isCanceled()) {
            return;
        }
        if (((Boolean)LCConfig.CLIENT.pushNotificationsToChat.get()).booleanValue()) {
            for (Component line : notification.getChatMessage()) {
                mc.gui.getChat().addMessage(line);
            }
        }
    }

    @Override
    public long getTimeDesync() {
        return this.timeOffset;
    }

    @Override
    public void setTimeDesync(long serverTime) {
        this.timeOffset = serverTime - System.currentTimeMillis();
        this.timeOffset = this.timeOffset / 1000L * 1000L;
        if (this.timeOffset < 10000L) {
            this.timeOffset = 0L;
        }
    }

    @Override
    public void loadAdminPlayers(List<UUID> serverAdminList) {
        LCAdminMode.loadAdminPlayers(serverAdminList);
    }

    @Override
    public void playCoinSound() {
        if (((Boolean)LCConfig.CLIENT.moneyMendingClink.get()).booleanValue()) {
            Minecraft minecraft = Minecraft.getInstance();
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)ModSounds.COINS_CLINKING.get(), (float)1.0f, (float)0.4f));
        }
    }

    @Override
    @Nullable
    public Level getDimension(boolean isClient, ResourceKey<Level> type) {
        if (isClient) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null && mc.level.dimension().location().equals((Object)type.location())) {
                return mc.level;
            }
            return null;
        }
        return super.getDimension(isClient, type);
    }

    @Override
    public Level safeGetDummyLevel() {
        Level level = this.getDummyLevelFromServer();
        if (level == null) {
            level = Minecraft.getInstance().level;
        }
        if (level != null) {
            return level;
        }
        LightmansCurrency.LogWarning("Could not get dummy level from client, as there is no active level!");
        return null;
    }

    @Override
    public boolean getHasPermissionsSetting() {
        Player player = this.getLocalPlayer();
        if (player == null) {
            return false;
        }
        return (Boolean)Minecraft.getInstance().options.operatorItemsTab().get() != false && player.canUseGameMasterBlocks();
    }

    @Override
    public void loadPlayerTrade(ClientPlayerTrade trade) {
        Minecraft mc = Minecraft.getInstance();
        AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
        if (abstractContainerMenu instanceof PlayerTradeMenu) {
            PlayerTradeMenu menu = (PlayerTradeMenu)abstractContainerMenu;
            menu.reloadTrade(trade);
        }
    }

    @Override
    public void syncEventUnlocks(List<String> unlocksList) {
        Minecraft mc = Minecraft.getInstance();
        EventUnlocks unlocks = (EventUnlocks)mc.player.getData(ModAttachmentTypes.EVENT_UNLOCKS);
        if (unlocks != null) {
            unlocks.sync(unlocksList);
        }
    }

    @Override
    public void sendClientMessage(Component message) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.sendSystemMessage(message);
        }
    }

    @Override
    public List<GameProfile> getPlayerList(boolean logicalClient) {
        if (!logicalClient) {
            return super.getPlayerList(logicalClient);
        }
        return Minecraft.getInstance().getConnection().getOnlinePlayers().stream().map(PlayerInfo::getProfile).toList();
    }

    @Override
    public boolean isSelf(Player player) {
        return player == Minecraft.getInstance().player;
    }

    @Override
    @Nullable
    public Player getLocalPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    public RegistryAccess getClientRegistryHolder() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            return level.registryAccess();
        }
        return null;
    }
}

