/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import javax.annotation.Nonnull;

public class EnumUtil {
    @Nonnull
    public static <T extends Enum<?>> Codec<T> buildCodec(@Nonnull Class<T> clazz, @Nonnull String name) {
        return Codec.STRING.comapFlatMap(string -> {
            Enum result = EnumUtil.enumFromString((String)string, (Enum[])((Enum[])clazz.getEnumConstants()), null);
            if (result == null) {
                return DataResult.error(() -> string + " is not a valid " + name);
            }
            return DataResult.success((Object)result);
        }, Enum::toString);
    }

    public static <T extends Enum<?>> T nextEnum(T value) {
        Enum[] allValues = (Enum[])value.getClass().getEnumConstants();
        return (T)EnumUtil.enumFromOrdinal((int)(value.ordinal() + 1), (Enum[])allValues, (Enum)allValues[0]);
    }

    public static <T extends Enum<?>> T previousEnum(T value) {
        Enum[] allValues = (Enum[])value.getClass().getEnumConstants();
        return (T)EnumUtil.enumFromOrdinal((int)(value.ordinal() - 1), (Enum[])allValues, (Enum)allValues[allValues.length - 1]);
    }

    public static <T extends Enum<?>> T enumFromOrdinal(int ordinal, T[] allValues, T defaultValue) {
        for (T val : allValues) {
            if (((Enum)val).ordinal() != ordinal) continue;
            return val;
        }
        return defaultValue;
    }

    public static <T extends Enum<?>> T enumFromString(String string, T[] allValues, T defaultValue) {
        for (T val : allValues) {
            if (!((Enum)val).toString().equalsIgnoreCase(string)) continue;
            return val;
        }
        return defaultValue;
    }
}

