/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.mojang.authlib.properties.PropertyMap;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;

public class ItemStackHelper {
    private static final Map<String, ItemStack> skullsByName = new HashMap<String, ItemStack>();
    private static final Map<UUID, ItemStack> skullsById = new HashMap<UUID, ItemStack>();

    public static ItemStack skullForPlayer(@Nonnull String playerName) {
        if (!skullsByName.containsKey(playerName)) {
            ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.of(playerName), Optional.empty(), new PropertyMap()));
            skullsByName.put(playerName, stack);
        }
        return skullsByName.get(playerName);
    }

    public static ItemStack skullForPlayer(@Nonnull UUID playerID) {
        if (!skullsById.containsKey(playerID)) {
            ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.empty(), Optional.of(playerID), new PropertyMap()));
            skullsById.put(playerID, stack);
        }
        return skullsById.get(playerID);
    }

    public static CompoundTag saveAllItems(String key, CompoundTag tag, NonNullList<ItemStack> list, HolderLookup.Provider lookup) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = (ItemStack)list.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag stackTag = InventoryUtil.saveItemNoLimits(stack, lookup);
            stackTag.putByte("Slot", (byte)i);
            listTag.add((Object)stackTag);
        }
        tag.put(key, (Tag)listTag);
        return tag;
    }

    public static void loadAllItems(String key, CompoundTag tag, NonNullList<ItemStack> list, HolderLookup.Provider lookup) {
        ListTag listTag = tag.getList(key, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag slotCompound = listTag.getCompound(i);
            int index = slotCompound.getByte("Slot") & 0xFF;
            if (index >= list.size()) continue;
            ItemStack stack = InventoryUtil.loadItemNoLimits(slotCompound, lookup);
            list.set(index, (Object)stack);
        }
    }

    public static boolean TagEquals(ItemStack stack1, ItemStack stack2) {
        return Objects.equals(stack1.getComponents(), stack2.getComponents());
    }
}

