/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConfigComments {
    public static final ConfigComments EMPTY = new ConfigComments();
    private final List<Object> comments;

    private ConfigComments() {
        this(new ArrayList());
    }

    private ConfigComments(List<?> comments) {
        this.comments = ImmutableList.copyOf(comments);
    }

    public List<String> getComments() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object entry : this.comments) {
            result.addAll(ConfigComments.castObject(entry));
        }
        return result;
    }

    private static List<String> castObject(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return ImmutableList.of((Object)string);
        }
        if (object instanceof Supplier) {
            Supplier supplier = (Supplier)object;
            return ConfigComments.castObject(supplier.get());
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            ArrayList<String> result = new ArrayList<String>();
            for (Object entry : collection) {
                result.addAll(ConfigComments.castObject(entry));
            }
            return result;
        }
        LightmansCurrency.LogWarning("Could not cast " + object.getClass().getName() + " to a comment list!");
        return ImmutableList.of();
    }

    private static Supplier<List<String>> castSupplier(Supplier<?> supplier) {
        return () -> ConfigComments.castObject(supplier.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Object> comments = new ArrayList<Object>();

        private Builder() {
        }

        public void add(Object ... comments) {
            this.comments.addAll(Lists.newArrayList((Object[])comments));
        }

        public void clear() {
            this.comments.clear();
        }

        public ConfigComments build() {
            return new ConfigComments(this.comments);
        }
    }
}

