/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.builtin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ResourceOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemOption
extends ConfigOption<Item> {
    public final Predicate<Item> filter;
    private final Parser parser;

    public static ConfigParser<Item> createParser(Predicate<Item> filter) {
        return new Parser(filter);
    }

    protected ItemOption(Supplier<Item> defaultValue, Predicate<Item> filter) {
        super(defaultValue);
        this.filter = filter;
        this.parser = new Parser(this.filter);
    }

    @Override
    protected ConfigParser<Item> getParser() {
        return this.parser;
    }

    public static ItemOption create(Supplier<Item> defaultValue) {
        return new ItemOption(defaultValue, i -> true);
    }

    public static ItemOption createNoAir(Supplier<Item> defaultValue) {
        return new ItemOption(defaultValue, i -> i != Items.f_41852_);
    }

    public static ItemOption createNoAir(Supplier<Item> defaultValue, Predicate<Item> filter) {
        return new ItemOption(defaultValue, filter);
    }

    @Override
    public boolean allowedValue(Item newValue) {
        return this.filter.test(newValue);
    }

    @Override
    @Nullable
    protected String bonusComment() {
        return "Default: " + this.parser.write((Item)this.getDefaultValue());
    }

    @Override
    @Nullable
    protected Component bonusCommentTooltip() {
        return LCText.CONFIG_OPTION_DEFAULT.get(new ItemStack((ItemLike)this.getDefaultValue()).m_41786_());
    }

    private static class Parser
    implements ConfigParser<Item> {
        private final Predicate<Item> filter;

        private Parser(Predicate<Item> filter) {
            this.filter = filter;
        }

        @Override
        public Item tryParse(String cleanLine) throws ConfigParsingException {
            if (cleanLine.isBlank() && this.filter.test(Items.f_41852_)) {
                return Items.f_41852_;
            }
            ResourceLocation itemID = ResourceOption.PARSER.tryParse(cleanLine);
            if (!ForgeRegistries.ITEMS.containsKey(itemID)) {
                throw new ConfigParsingException("No item found with id " + itemID + "!");
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemID);
            if (!this.filter.test(item)) {
                throw new ConfigParsingException(new ItemStack((ItemLike)item).m_41786_().getString() + " is not an allowed item!");
            }
            return item;
        }

        @Override
        public String write(Item value) {
            return ResourceOption.PARSER.write(ForgeRegistries.ITEMS.getKey((Object)value));
        }
    }
}

