/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.settings.client.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IDeepBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NormalSprite;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsObject;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.model.VariantBlockModel;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin.InputDisplayOffset;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DirectionalSettingsWidget
extends EasyWidgetWithChildren {
    private static final Map<Direction, Map<DirectionalSettingsState, FixedSizeSprite>> SIDED_SPRITE_CACHE = new HashMap<Direction, Map<DirectionalSettingsState, FixedSizeSprite>>();
    private static final Map<SideSize, Map<DirectionalSettingsState, FixedSizeSprite>> SIZED_SPRITE_CACHE = new HashMap<SideSize, Map<DirectionalSettingsState, FixedSizeSprite>>();
    public static final ResourceLocation BLOCK_SIDE_TEXTURE = VersionUtil.lcResource("textures/gui/blocksides.png");
    private static final List<Direction> DIRECTIONS = ImmutableList.of((Object)Direction.DOWN, (Object)Direction.UP, (Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST);
    private static final List<Direction> RENDER_DIRECTIONS = DIRECTIONS;
    private static final int SPACING = 4;
    private final Supplier<IDirectionalSettingsObject> objectSource;
    private final Consumer<Direction> onPress;
    private final Consumer<Direction> onAltPress;
    public boolean visible = true;

    private DirectionalSettingsWidget(Builder builder) {
        super(builder);
        this.objectSource = builder.objectSource;
        this.onPress = builder.handler;
        this.onAltPress = builder.altHandler;
    }

    @Override
    public void addChildren(ScreenArea area) {
        DisplayBlockAttributes attributes = DisplayBlockAttributes.of(this.objectSource);
        area = this.recalculateSize(attributes);
        for (Direction side : DIRECTIONS) {
            this.addChild(this.buttonForSide(area.pos.offset(attributes.getSidePos(side)), DirectionalSettingsWidget.spriteForSize(attributes.getSideSize(side), () -> this.stateForSide(side)), side));
        }
    }

    private ScreenArea recalculateSize(DisplayBlockAttributes attributes) {
        int width = 8;
        width += attributes.deep ? 32 : 16;
        width += attributes.wide ? 32 : 16;
        this.m_93674_(width += attributes.deep || attributes.wide ? 32 : 16);
        int height = 8;
        height += attributes.deep ? 32 : 16;
        height += attributes.tall ? 32 : 16;
        this.setHeight(height += attributes.tall || attributes.deep ? 32 : 16);
        this.m_252865_(this.m_252754_() - width / 2);
        return this.getArea();
    }

    private PlainButton buttonForSide(ScreenPosition position, Supplier<FixedSizeSprite> sprite, Direction side) {
        return ((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(position)).pressAction(() -> this.onButtonPress(side))).altPressAction(() -> this.onAltButtonPress(side))).sprite(sprite).drawInForeground().addon(EasyAddonHelper.tooltips(this.tooltipForSide(side)))).addon(EasyAddonHelper.visibleCheck(() -> this.isSideVisible(side)))).build();
    }

    private Supplier<List<Component>> tooltipForSide(Direction side) {
        return () -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(LCText.GUI_INPUT_SIDES.get(side).get(new Object[0]));
            DirectionalSettingsState state = this.stateForSide(side);
            if (state != DirectionalSettingsState.NONE) {
                list.add(state.getText());
            }
            return list;
        };
    }

    private DirectionalSettingsState stateForSide(Direction side) {
        IDirectionalSettingsObject parent = this.objectSource.get();
        return parent == null ? DirectionalSettingsState.NONE : parent.getSidedState(side);
    }

    private boolean isSideVisible(Direction side) {
        IDirectionalSettingsObject parent = this.objectSource.get();
        return this.isVisible() && parent != null && !parent.getIgnoredSides().contains(side);
    }

    @Override
    protected void renderWidget(EasyGuiGraphics gui) {
        gui.pushOffset(this);
        DisplayBlockAttributes attributes = DisplayBlockAttributes.of(this.objectSource);
        if (attributes.isNull()) {
            for (Direction side : DIRECTIONS) {
                if (!this.isSideVisible(side)) continue;
                gui.blit(BLOCK_SIDE_TEXTURE, attributes.getSidePos(side), 96 + 16 * DIRECTIONS.indexOf(side), 0, 16, 16);
            }
        } else {
            ModelVariant variant;
            ItemStack item = new ItemStack((ItemLike)attributes.displayBlock.m_5456_());
            PoseStack pose = gui.getPose();
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            gui.pushOffset(ScreenPosition.ZERO);
            InputDisplayOffset offset = null;
            if (attributes.variant != null && (variant = ModelVariantDataManager.getVariant(attributes.variant)) != null && variant.has(VariantProperties.INPUT_DISPLAY_OFFSET)) {
                offset = variant.get(VariantProperties.INPUT_DISPLAY_OFFSET);
            }
            for (Direction side : RENDER_DIRECTIONS) {
                if (!this.isSideVisible(side)) continue;
                Quaternionf rotation = attributes.getSideRotation(side);
                BlockState defaultState = attributes.displayBlock.m_49966_();
                if (attributes.displayBlock instanceof IRotatableBlock) {
                    defaultState.m_61124_((Property)IRotatableBlock.FACING, (Comparable)Direction.NORTH);
                }
                PendingDrawStates statesToDraw = new PendingDrawStates();
                switch (side) {
                    case WEST: {
                        BlockState topState;
                        BlockState bottomState;
                        if (attributes.wide) {
                            defaultState = (BlockState)defaultState.m_61124_((Property)IWideBlock.ISLEFT, (Comparable)Boolean.valueOf(true));
                        }
                        if (attributes.tall) {
                            bottomState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(true));
                            topState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(false));
                            if (attributes.deep) {
                                attributes.addDepthStates(statesToDraw, ScreenPosition.of(16, 0), ScreenPosition.of(0, 0), topState);
                                attributes.addDepthStates(statesToDraw, ScreenPosition.of(16, 16), ScreenPosition.of(0, 16), bottomState);
                                break;
                            }
                            statesToDraw.add(0, 0, topState);
                            statesToDraw.add(0, 16, bottomState);
                            break;
                        }
                        if (attributes.deep) {
                            attributes.addDepthStates(statesToDraw, ScreenPosition.of(16, 0), ScreenPosition.of(0, 0), defaultState);
                            break;
                        }
                        statesToDraw.add(0, 0, defaultState);
                        break;
                    }
                    case EAST: {
                        BlockState topState;
                        BlockState bottomState;
                        if (attributes.wide) {
                            defaultState = (BlockState)defaultState.m_61124_((Property)IWideBlock.ISLEFT, (Comparable)Boolean.valueOf(false));
                        }
                        if (attributes.tall) {
                            bottomState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(true));
                            topState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(false));
                            if (attributes.deep) {
                                attributes.addDepthStates(statesToDraw, ScreenPosition.of(0, 0), ScreenPosition.of(16, 0), topState);
                                attributes.addDepthStates(statesToDraw, ScreenPosition.of(0, 16), ScreenPosition.of(16, 16), bottomState);
                                break;
                            }
                            statesToDraw.add(0, 0, topState);
                            statesToDraw.add(0, 16, bottomState);
                            break;
                        }
                        if (attributes.deep) {
                            attributes.addDepthStates(statesToDraw, ScreenPosition.of(0, 0), ScreenPosition.of(16, 0), defaultState);
                            break;
                        }
                        statesToDraw.add(0, 0, defaultState);
                        break;
                    }
                    case SOUTH: {
                        BlockState bottomState;
                        BlockState topState;
                        if (attributes.deep) {
                            defaultState = (BlockState)defaultState.m_61124_((Property)IDeepBlock.IS_FRONT, (Comparable)Boolean.valueOf(true));
                        }
                        if (attributes.tall) {
                            topState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(false));
                            bottomState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(true));
                            if (attributes.wide) {
                                attributes.addWidthStates(statesToDraw, ScreenPosition.of(0, 0), ScreenPosition.of(16, 0), topState);
                                attributes.addWidthStates(statesToDraw, ScreenPosition.of(0, 16), ScreenPosition.of(16, 16), bottomState);
                                break;
                            }
                            statesToDraw.add(0, 0, topState);
                            statesToDraw.add(0, 16, bottomState);
                            break;
                        }
                        if (attributes.wide) {
                            attributes.addWidthStates(statesToDraw, ScreenPosition.of(0, 0), ScreenPosition.of(16, 0), defaultState);
                            break;
                        }
                        statesToDraw.add(0, 0, defaultState);
                        break;
                    }
                    case NORTH: {
                        BlockState bottomState;
                        BlockState topState;
                        if (attributes.deep) {
                            defaultState = (BlockState)defaultState.m_61124_((Property)IDeepBlock.IS_FRONT, (Comparable)Boolean.valueOf(false));
                        }
                        if (attributes.tall) {
                            topState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(false));
                            bottomState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(true));
                            if (attributes.wide) {
                                attributes.addWidthStates(statesToDraw, ScreenPosition.of(16, 0), ScreenPosition.of(0, 0), topState);
                                attributes.addWidthStates(statesToDraw, ScreenPosition.of(16, 16), ScreenPosition.of(0, 16), bottomState);
                                break;
                            }
                            statesToDraw.add(0, 0, topState);
                            statesToDraw.add(0, 16, bottomState);
                            break;
                        }
                        if (attributes.wide) {
                            attributes.addWidthStates(statesToDraw, ScreenPosition.of(16, 0), ScreenPosition.of(0, 0), defaultState);
                            break;
                        }
                        statesToDraw.add(0, 0, defaultState);
                        break;
                    }
                    case UP: {
                        BlockState backState;
                        BlockState frontState;
                        if (attributes.tall) {
                            defaultState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(false));
                        }
                        if (attributes.deep) {
                            frontState = (BlockState)defaultState.m_61124_((Property)IDeepBlock.IS_FRONT, (Comparable)Boolean.valueOf(true));
                            backState = (BlockState)defaultState.m_61124_((Property)IDeepBlock.IS_FRONT, (Comparable)Boolean.valueOf(false));
                            if (attributes.wide) {
                                attributes.addWidthStates(statesToDraw, ScreenPosition.of(0, 0), ScreenPosition.of(16, 0), backState);
                                attributes.addWidthStates(statesToDraw, ScreenPosition.of(0, 16), ScreenPosition.of(16, 16), frontState);
                                break;
                            }
                            statesToDraw.add(0, 0, backState);
                            statesToDraw.add(0, 16, frontState);
                            break;
                        }
                        if (attributes.wide) {
                            attributes.addWidthStates(statesToDraw, ScreenPosition.of(0, 0), ScreenPosition.of(16, 0), defaultState);
                            break;
                        }
                        statesToDraw.add(0, 0, defaultState);
                        break;
                    }
                    case DOWN: {
                        BlockState backState;
                        BlockState frontState;
                        if (attributes.tall) {
                            defaultState = (BlockState)defaultState.m_61124_((Property)ITallBlock.ISBOTTOM, (Comparable)Boolean.valueOf(true));
                        }
                        if (attributes.deep) {
                            frontState = (BlockState)defaultState.m_61124_((Property)IDeepBlock.IS_FRONT, (Comparable)Boolean.valueOf(true));
                            backState = (BlockState)defaultState.m_61124_((Property)IDeepBlock.IS_FRONT, (Comparable)Boolean.valueOf(false));
                            if (attributes.wide) {
                                attributes.addWidthStates(statesToDraw, ScreenPosition.of(0, 0), ScreenPosition.of(16, 0), frontState);
                                attributes.addWidthStates(statesToDraw, ScreenPosition.of(0, 16), ScreenPosition.of(16, 16), backState);
                                break;
                            }
                            statesToDraw.add(0, 0, frontState);
                            statesToDraw.add(0, 16, backState);
                            break;
                        }
                        if (attributes.wide) {
                            attributes.addWidthStates(statesToDraw, ScreenPosition.of(0, 0), ScreenPosition.of(16, 0), defaultState);
                            break;
                        }
                        statesToDraw.add(0, 0, defaultState);
                    }
                }
                ScreenPosition position = attributes.getSideRenderPos(side).offset(this.getPosition());
                RenderSystem.enableBlend();
                for (Pair<ScreenPosition, BlockState> stateToDraw : statesToDraw.statesToDraw) {
                    pose.m_85836_();
                    pose.m_252880_((float)position.x, (float)position.y, 32.0f);
                    pose.m_252880_((float)((ScreenPosition)stateToDraw.getFirst()).x, (float)((ScreenPosition)stateToDraw.getFirst()).y, 0.0f);
                    if (offset != null) {
                        ScreenPosition temp = offset.getOffset(side);
                        pose.m_252880_((float)temp.x, (float)temp.y, 0.0f);
                    }
                    pose.m_252781_(rotation);
                    pose.m_85841_(16.0f, -16.0f, 16.0f);
                    ModelData modelData = ModelData.EMPTY;
                    if (attributes.variant != null) {
                        modelData = ModelData.builder().with(VariantBlockModel.VARIANT, (Object)attributes.variant).with(VariantBlockModel.STATE, (Object)((BlockState)stateToDraw.getSecond())).build();
                    }
                    blockRenderer.renderSingleBlock((BlockState)stateToDraw.getSecond(), pose, (MultiBufferSource)gui.getGui().m_280091_(), 0xF000F0, OverlayTexture.f_118083_, modelData, RenderType.m_110463_());
                    pose.m_85849_();
                }
                RenderSystem.disableBlend();
            }
            gui.popOffset();
        }
        gui.popOffset();
    }

    private static Supplier<FixedSizeSprite> spriteForSide(Direction side, Supplier<DirectionalSettingsState> value) {
        return () -> DirectionalSettingsWidget.getSprite(side, (DirectionalSettingsState)((Object)((Object)value.get())));
    }

    private static FixedSizeSprite getSprite(Direction side, DirectionalSettingsState state) {
        Map<DirectionalSettingsState, FixedSizeSprite> stateMap;
        if (!SIDED_SPRITE_CACHE.containsKey(side)) {
            SIDED_SPRITE_CACHE.put(side, new HashMap());
        }
        if (!(stateMap = SIDED_SPRITE_CACHE.get(side)).containsKey((Object)state)) {
            stateMap.put(state, new NormalSprite(new SpriteSource(BLOCK_SIDE_TEXTURE, DirectionalSettingsWidget.getSideU(side), state.ordinal() * 16, 16, 16)));
        }
        return stateMap.get((Object)state);
    }

    private static Supplier<FixedSizeSprite> spriteForSize(SideSize size, Supplier<DirectionalSettingsState> value) {
        return () -> DirectionalSettingsWidget.getSprite(size, (DirectionalSettingsState)((Object)((Object)value.get())));
    }

    private static FixedSizeSprite getSprite(SideSize size, DirectionalSettingsState state) {
        Map<DirectionalSettingsState, FixedSizeSprite> stateMap;
        if (!SIZED_SPRITE_CACHE.containsKey((Object)size)) {
            SIZED_SPRITE_CACHE.put(size, new HashMap());
        }
        if (!(stateMap = SIZED_SPRITE_CACHE.get((Object)size)).containsKey((Object)state)) {
            stateMap.put(state, size.spriteForState(state));
        }
        return stateMap.get((Object)state);
    }

    private int getSidePosX(Direction side) {
        return switch (side) {
            case Direction.SOUTH, Direction.UP, Direction.DOWN -> 20;
            case Direction.EAST, Direction.NORTH -> 40;
            default -> 0;
        };
    }

    private int getSidePosY(Direction side) {
        return switch (side) {
            case Direction.WEST, Direction.EAST, Direction.SOUTH -> 20;
            case Direction.NORTH, Direction.DOWN -> 40;
            default -> 0;
        };
    }

    private static int getSideU(Direction side) {
        return side.m_122411_() * 16;
    }

    private void onButtonPress(Direction side) {
        this.onPress.accept(side);
    }

    private void onAltButtonPress(Direction side) {
        this.onAltPress.accept(side);
    }

    @Override
    public boolean hideFromMouse() {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private Supplier<IDirectionalSettingsObject> objectSource = () -> null;
        private Consumer<Direction> handler = d -> {};
        private Consumer<Direction> altHandler = d -> {};

        private Builder() {
            super(0, 0);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder object(Supplier<IDirectionalSettingsObject> objectSource) {
            this.objectSource = objectSource;
            return this;
        }

        public Builder handler(Consumer<Direction> handler) {
            this.handler = handler;
            return this;
        }

        public Builder altHandler(Consumer<Direction> handler) {
            this.altHandler = handler;
            return this;
        }

        public Builder handlers(BiConsumer<Direction, Boolean> handler) {
            this.handler = s -> handler.accept((Direction)s, false);
            this.altHandler = s -> handler.accept((Direction)s, true);
            return this;
        }

        public DirectionalSettingsWidget build() {
            return new DirectionalSettingsWidget(this);
        }
    }

    private static class DisplayBlockAttributes {
        public static final DisplayBlockAttributes NULL = new DisplayBlockAttributes(null, null);
        final boolean tall;
        final int blockHeight;
        final boolean wide;
        final int blockWidth;
        final boolean deep;
        final int blockDepth;
        final Block displayBlock;
        final ResourceLocation variant;

        public final boolean isNull() {
            return this.displayBlock == null;
        }

        private DisplayBlockAttributes(@Nullable Block displayBlock, @Nullable ResourceLocation variant) {
            this.displayBlock = displayBlock;
            this.variant = variant;
            this.tall = this.displayBlock instanceof ITallBlock;
            this.blockHeight = this.tall ? 2 : 1;
            this.wide = this.displayBlock instanceof IWideBlock;
            this.blockWidth = this.wide ? 2 : 1;
            this.deep = this.displayBlock instanceof IDeepBlock;
            this.blockDepth = this.deep ? 2 : 1;
        }

        public static DisplayBlockAttributes of(Supplier<IDirectionalSettingsObject> objectSource) {
            Block displayBlock;
            IDirectionalSettingsObject parent = objectSource.get();
            Block block = displayBlock = parent == null ? null : parent.getDisplayBlock();
            if (displayBlock != null) {
                return new DisplayBlockAttributes(displayBlock, parent.getVariant());
            }
            return NULL;
        }

        public ScreenPosition getSidePos(Direction side) {
            return ScreenPosition.of(this.getSidePosX(side), this.getSidePosY(side));
        }

        public int getSidePosX(Direction side) {
            return switch (side) {
                case Direction.WEST -> 0;
                case Direction.SOUTH, Direction.UP, Direction.DOWN -> this.blockDepth * 16 + 4;
                default -> this.blockDepth * 16 + this.blockWidth * 16 + 4 + 4;
            };
        }

        public int getSidePosY(Direction side) {
            return switch (side) {
                case Direction.UP -> 0;
                case Direction.WEST, Direction.EAST, Direction.SOUTH -> this.blockDepth * 16 + 4;
                default -> this.blockDepth * 16 + this.blockHeight * 16 + 4 + 4;
            };
        }

        public ScreenPosition getSideRenderPos(Direction side) {
            ScreenPosition pos = this.getSidePos(side).offset(0, 16);
            return switch (side) {
                case Direction.EAST, Direction.NORTH -> pos.offset(16, 0);
                case Direction.UP -> pos.offset(0, -16);
                default -> pos;
            };
        }

        public SideSize getSideSize(Direction side) {
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.WEST, Direction.EAST -> SideSize.of(this.deep, this.tall);
                case Direction.UP, Direction.DOWN -> SideSize.of(this.wide, this.deep);
                case Direction.SOUTH, Direction.NORTH -> SideSize.of(this.wide, this.tall);
            };
        }

        public Quaternionf getSideRotation(Direction side) {
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.WEST -> MathUtil.fromAxisAngleDegree(MathUtil.getYP(), 90.0f);
                case Direction.EAST -> MathUtil.fromAxisAngleDegree(MathUtil.getYP(), -90.0f);
                case Direction.SOUTH -> new Quaternionf();
                case Direction.NORTH -> MathUtil.fromAxisAngleDegree(MathUtil.getYP(), 180.0f);
                case Direction.UP -> MathUtil.fromAxisAngleDegree(MathUtil.getXP(), -90.0f);
                case Direction.DOWN -> MathUtil.fromAxisAngleDegree(MathUtil.getXP(), 90.0f);
            };
        }

        public void addWidthStates(PendingDrawStates list, ScreenPosition leftPos, ScreenPosition rightPos, BlockState defaultState) {
            BlockState temp = (BlockState)defaultState.m_61124_((Property)IWideBlock.ISLEFT, (Comparable)Boolean.valueOf(true));
            list.add(leftPos, temp);
            temp = (BlockState)defaultState.m_61124_((Property)IWideBlock.ISLEFT, (Comparable)Boolean.valueOf(false));
            list.add(rightPos, temp);
        }

        public void addDepthStates(PendingDrawStates list, ScreenPosition frontPos, ScreenPosition backPos, BlockState defaultState) {
            BlockState temp = (BlockState)defaultState.m_61124_((Property)IDeepBlock.IS_FRONT, (Comparable)Boolean.valueOf(true));
            list.add(frontPos, temp);
            temp = (BlockState)defaultState.m_61124_((Property)IDeepBlock.IS_FRONT, (Comparable)Boolean.valueOf(false));
            list.add(backPos, temp);
        }
    }

    static enum SideSize {
        ONE_BY_ONE(0, 16, 16),
        TWO_BY_ONE(16, 32, 16),
        ONE_BY_TWO(48, 16, 32),
        TWO_BY_TWO(64, 32, 32);

        private final int uPos;
        private final int uSize;
        private final int vSize;

        private SideSize(int uPos, int uSize, int vSize) {
            this.uPos = uPos;
            this.uSize = uSize;
            this.vSize = vSize;
        }

        private FixedSizeSprite spriteForState(DirectionalSettingsState state) {
            return new NormalSprite(new SpriteSource(BLOCK_SIDE_TEXTURE, this.uPos, this.vSize * state.ordinal(), this.uSize, this.vSize));
        }

        static SideSize of(boolean wide, boolean tall) {
            return wide ? (tall ? TWO_BY_TWO : TWO_BY_ONE) : (tall ? ONE_BY_TWO : ONE_BY_ONE);
        }
    }

    private static class PendingDrawStates {
        private final List<Pair<ScreenPosition, BlockState>> statesToDraw = new ArrayList<Pair<ScreenPosition, BlockState>>();

        private PendingDrawStates() {
        }

        public void add(int x, int y, BlockState state) {
            this.statesToDraw.add((Pair<ScreenPosition, BlockState>)Pair.of((Object)ScreenPosition.of(x, y), (Object)state));
        }

        public void add(ScreenPosition position, BlockState state) {
            this.statesToDraw.add((Pair<ScreenPosition, BlockState>)Pair.of((Object)position, (Object)state));
        }
    }
}

