/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.bank;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.menu.IBankAccountAdvancedMenu;
import io.github.lightman314.lightmanscurrency.api.money.bank.menu.IBankAccountMenu;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReferenceType;
import io.github.lightman314.lightmanscurrency.api.money.bank.source.BankAccountSource;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.common.impl.BankAPIImpl;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class BankAPI {
    private static BankAPI instance = null;

    public static BankAPI getApi() {
        if (instance == null) {
            instance = new BankAPIImpl();
        }
        return instance;
    }

    protected BankAPI() {
        if (instance != null) {
            throw new IllegalCallerException("Cannot create a new BankAPI instance as one is already present!");
        }
    }

    public abstract void RegisterReferenceType(BankReferenceType var1);

    public abstract void RegisterBankAccountSource(BankAccountSource var1);

    @Nullable
    public abstract BankReferenceType GetReferenceType(ResourceLocation var1);

    public abstract List<IBankAccount> GetAllBankAccounts(boolean var1);

    public final List<IBankAccount> GetAllBankAccounts(IClientTracker context) {
        return this.GetAllBankAccounts(context.isClient());
    }

    public abstract List<BankReference> GetAllBankReferences(boolean var1);

    public final List<BankReference> GetAllBankReferences(IClientTracker context) {
        return this.GetAllBankReferences(context.isClient());
    }

    public abstract void BankDeposit(IBankAccountMenu var1, MoneyValue var2);

    public abstract void BankDeposit(Player var1, Container var2, BankReference var3, MoneyValue var4);

    public final boolean BankDepositFromServer(IBankAccount account, MoneyValue amount) {
        return this.BankDepositFromServer(account, amount, true);
    }

    public abstract boolean BankDepositFromServer(IBankAccount var1, MoneyValue var2, boolean var3);

    public final Pair<Boolean, MoneyValue> BankWithdrawFromServer(IBankAccount account, MoneyValue amount) {
        return this.BankWithdrawFromServer(account, amount, true);
    }

    public abstract Pair<Boolean, MoneyValue> BankWithdrawFromServer(IBankAccount var1, MoneyValue var2, boolean var3);

    public abstract void BankWithdraw(IBankAccountMenu var1, MoneyValue var2);

    public abstract void BankWithdraw(Player var1, Container var2, BankReference var3, MoneyValue var4);

    public abstract MutableComponent BankTransfer(IBankAccountAdvancedMenu var1, MoneyValue var2, IBankAccount var3);

    public abstract MutableComponent BankTransfer(Player var1, BankReference var2, MoneyValue var3, IBankAccount var4);
}

